package com.pcloud.book.adnews.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/17 16:13
 **/
@Data
@ApiModel("编辑新闻发送记录")
public class AdNewsSet extends BaseEntity {

    private static final long serialVersionUID = -1115799214395961840L;

    @ApiModelProperty("早报时间")
    private String morningTime;

    @ApiModelProperty("晚报时间")
    private String eveningTime;

    @ApiModelProperty("是否开启早报")
    private Boolean hasMorningOpen;

    @ApiModelProperty("是否开启晚报")
    private Boolean hasEveningOpen;

    @ApiModelProperty("发送次数")
    private Integer sendCount;

    @ApiModelProperty("开场语")
    private String startContent;

    @ApiModelProperty("结束语")
    private String endContent;

    @ApiModelProperty("是否开启开场语")
    private Boolean hasStartContent;

    @ApiModelProperty("是否开启结束语")
    private Boolean hasEndContent;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @ApiModelProperty("内容来源")
    private Integer contentFrom;

    @ApiModelProperty("早报内容")
    private String morningContent;

    @ApiModelProperty("晚报内容")
    private String eveningContent;

    @ApiModelProperty("内容类型")
    private Integer contentType;

    @ApiModelProperty("分类关联集合")
    private List<AdNewsGroup> adNewsGroups;

    @ApiModelProperty("分类id集合")
    private List<Long> classifyIds;

    @ApiModelProperty("自有公众号")
    private List<AdNewsWechat> adNewsWechats;

}
