package com.pcloud.book.advertising.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;
import java.util.List;

/**
 * @描述：用户报名信息
 * @作者：zhuyajie
 * @创建时间：20:19 2019/6/28
 * @版本：1.0
 */
public class BmRegisterDTO extends BaseDto{
    private Long id;
    /**
     *用户id
     */
    private Long userId;
    /**
     *广告id
     */
    private Long adId;
    /**
     *用户昵称
     */
    private String nickName;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    /**
     * 报名选项信息
     */
    private List<BmRegisterItemDTO> registerItemDTOS;

    /**
     * 群二维码id
     */
    private Long qrcodeId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public List<BmRegisterItemDTO> getRegisterItemDTOS() {
        return registerItemDTOS;
    }

    public void setRegisterItemDTOS(List<BmRegisterItemDTO> registerItemDTOS) {
        this.registerItemDTOS = registerItemDTOS;
    }

    public Long getQrcodeId() {
        return qrcodeId;
    }

    public void setQrcodeId(Long qrcodeId) {
        this.qrcodeId = qrcodeId;
    }

    @Override
    public String toString() {
        return "BmRegisterDTO{" +
                "id=" + id +
                ", userId=" + userId +
                ", adId=" + adId +
                ", nickName='" + nickName + '\'' +
                ", createTime=" + createTime +
                ", registerItemDTOS=" + registerItemDTOS +
                ", qrcodeId=" + qrcodeId +
                '}';
    }
}
