package com.pcloud.book.advertising.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.pcloud.common.entity.BaseEntity;

public class AdvertisingIncomeDaily extends BaseEntity {

    private static final long serialVersionUID = 2993939729052080207L;

    /**
     * advertising_income_daily.id (唯一标识)
     */
    private Long id;

    /**
     * advertising_income_daily.ad_id (广告位ID)
     */
    private Long adId;

    /**
     * advertising_income_daily.master_id (广告主ID)
     */
    private Long masterId;

    /**
     * advertising_income_daily.book_id (书刊ID)
     */
    private Long bookId;

    /**
     * 运营ID
     */
    private Long channelId;

    /**
     * advertising_income_daily.classify_id (分类ID)
     */
    private Long classifyId;

    /**
     * advertising_income_daily.qrcode_id (微信群ID)
     */
    private Long qrcodeId;

    /**
     * advertising_income_daily.settlement_method (结算方式编码)
     */
    private String settlementMethod;

    /**
     * advertising_income_daily.price_each_time (价格)
     */
    private BigDecimal priceEachTime;

    /**
     * advertising_income_daily.exposure_num (曝光量)
     */
    private Integer exposureNum;

    /**
     * advertising_income_daily.click_num (点击量)
     */
    private Integer clickNum;

    /**
     * advertising_income_daily.income (收益)
     */
    private BigDecimal income;

    /**
     * advertising_income_daily.create_time (创建时间)
     */
    private Date createTime;

    /**
     * advertising_income_daily.statis_day (统计日期)
     */
    private Date statisDay;

    /**
     * advertising_income_daily.statis_month (统计月份)
     */
    private String statisMonth;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public Long getMasterId() {
        return masterId;
    }

    public void setMasterId(Long masterId) {
        this.masterId = masterId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Long getQrcodeId() {
        return qrcodeId;
    }

    public void setQrcodeId(Long qrcodeId) {
        this.qrcodeId = qrcodeId;
    }

    public String getSettlementMethod() {
        return settlementMethod;
    }

    public void setSettlementMethod(String settlementMethod) {
        this.settlementMethod = settlementMethod;
    }

    public BigDecimal getPriceEachTime() {
        return priceEachTime;
    }

    public void setPriceEachTime(BigDecimal priceEachTime) {
        this.priceEachTime = priceEachTime;
    }

    public Integer getExposureNum() {
        return exposureNum;
    }

    public void setExposureNum(Integer exposureNum) {
        this.exposureNum = exposureNum;
    }

    public Integer getClickNum() {
        return clickNum;
    }

    public void setClickNum(Integer clickNum) {
        this.clickNum = clickNum;
    }

    public BigDecimal getIncome() {
        return income;
    }

    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getStatisDay() {
        return statisDay;
    }

    public void setStatisDay(Date statisDay) {
        this.statisDay = statisDay;
    }

    public String getStatisMonth() {
        return statisMonth;
    }

    public void setStatisMonth(String statisMonth) {
        this.statisMonth = statisMonth;
    }

    @Override
    public String toString() {
        return "AdvertisingIncomeDaily{" +
                "id=" + id +
                ", adId=" + adId +
                ", masterId=" + masterId +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", classifyId=" + classifyId +
                ", qrcodeId=" + qrcodeId +
                ", settlementMethod='" + settlementMethod + '\'' +
                ", priceEachTime=" + priceEachTime +
                ", exposureNum=" + exposureNum +
                ", clickNum=" + clickNum +
                ", income=" + income +
                ", createTime=" + createTime +
                ", statisDay=" + statisDay +
                ", statisMonth='" + statisMonth + '\'' +
                "} " + super.toString();
    }
}