/**
 *
 */
package com.pcloud.book.consumer.message;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.pcloud.common.core.biz.MessageBiz;
import com.pcloud.common.core.dto.SendNotifyDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.string.StringUtil;

/**
 * @描述：消息中心中间件
 * @作者：songx
 * @创建时间：2016年11月23日,下午5:08:44
 * @版本：1.0
 */
@Component("messageConsr")
public class MessageConsr {

    /**
     *
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageConsr.class);

    @Autowired
    private MessageBiz messageBiz;

    /**
     * 发送站内信
     */
    public void sendLetter(Long fromId, Long toId, String content, String sysCode, String typeCode, String resourceId, String fileName)
            throws BizException {
        LOGGER.info("【站内信-消息(消)】发送站内信,<START>.[fromId]=" + fromId + ",[toId]=" + toId + ",[content]=" + content
                + ",[sysCode]=" + sysCode + ",[typeCode]=" + typeCode + ",[resourceId]=" + resourceId + ",fileName=" + fileName);
        if (fromId == null || toId == null || StringUtil.isEmpty(content) || StringUtil.isEmpty(sysCode)
                || StringUtil.isEmpty(typeCode) || resourceId == null) {
            return;
        }
        // 组装参数
        SendNotifyDto sendNotifyDto = new SendNotifyDto();
        sendNotifyDto.setCreatedTime(new Date());
        sendNotifyDto.setFromId(fromId);
        sendNotifyDto.setToId(toId);
        sendNotifyDto.setNotifyContent(content);
        sendNotifyDto.setSystemCode(sysCode);
        sendNotifyDto.setTypeCode(typeCode);
        sendNotifyDto.setResourceId(resourceId);
        sendNotifyDto.setFileName(fileName);
        try {
            messageBiz.sendLetter(sendNotifyDto);
        } catch (Exception e) {
            LOGGER.error("【站内信(消)】发送站内信.[sendLetter]:" + e.getMessage(), e);
        }
        LOGGER.info("【站内信(消)】发送站内信,<END>");
    }

    /**
     * 发送站内信
     */
    public void sendLetter(Long fromId, Long toId, String content, String sysCode, String typeCode, String resourceId, String fileName, String originType, String originId)
            throws BizException {
        LOGGER.info("【站内信-消息(消)】发送站内信,<START>.[fromId]=" + fromId + ",[toId]=" + toId + ",[content]=" + content
                + ",[sysCode]=" + sysCode + ",[typeCode]=" + typeCode + ",[resourceId]=" + resourceId + ",fileName=" + fileName);
        if (fromId == null || toId == null || StringUtil.isEmpty(content) || StringUtil.isEmpty(sysCode)
                || StringUtil.isEmpty(typeCode) || resourceId == null) {
            return;
        }
        // 组装参数
        SendNotifyDto sendNotifyDto = new SendNotifyDto();
        sendNotifyDto.setCreatedTime(new Date());
        sendNotifyDto.setFromId(fromId);
        sendNotifyDto.setToId(toId);
        sendNotifyDto.setNotifyContent(content);
        sendNotifyDto.setSystemCode(sysCode);
        sendNotifyDto.setTypeCode(typeCode);
        sendNotifyDto.setResourceId(resourceId);
        sendNotifyDto.setFileName(fileName);
        sendNotifyDto.setOriginType(originType);
        sendNotifyDto.setOriginId(originId);
        try {
            messageBiz.sendLetter(sendNotifyDto);
        } catch (Exception e) {
            LOGGER.error("【站内信(消)】发送站内信.[sendLetter]:" + e.getMessage(), e);
        }
        LOGGER.info("【站内信(消)】发送站内信,<END>");
    }

}
