package com.pcloud.book.copyright.dao.impl;

import com.pcloud.book.copyright.dao.BookAuthCodeDao;
import com.pcloud.book.copyright.dto.BookAuthCodeDTO;
import com.pcloud.book.copyright.entity.BookAuthCode;
import com.pcloud.common.core.dao.BaseDaoImpl;
import com.pcloud.common.page.PageBeanNew;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/4 19:32
 */
@Component("bookAuthCodeDao")
public class BookAuthCodeDaoImpl extends BaseDaoImpl<BookAuthCode> implements BookAuthCodeDao {

    @Override
    public Integer getMaxBatchNum(Long bookId, Long channelId, Long adviserId, Integer authBookType) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        if(authBookType == null || authBookType.equals(0)) {
            paramMap.put("isPaperBook", 1);
        } else {
            paramMap.put("isGroupBook", 1);
        }
        return this.getSqlSession().selectOne(this.getStatement("getMaxBatchNum"), paramMap);
    }

    @Override
    public Integer updateUseCount(Long bookId, Long channelId, Long adviserId, String code, Integer codeUseCount, Integer authBookType) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("codeUseCount",codeUseCount);
        paramMap.put("code",code);
        if(authBookType == null || authBookType.equals(0)) {
            paramMap.put("isPaperBook", 1);
        } else {
            paramMap.put("isGroupBook", 1);
        }
        return this.getSqlSession().update(this.getStatement("updateUseCount"), paramMap);
    }

    @Override
    public Boolean getIsHaveCode(Long bookId, Long channelId, Long adviserId, String code, Integer authBookType) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("code",code);
        if(authBookType == null || authBookType.equals(0)) {
            paramMap.put("isPaperBook", 1);
        } else {
            paramMap.put("isGroupBook", 1);
        }
        return this.getSqlSession().selectOne(this.getStatement("getIsHaveCode"), paramMap);
    }

    @Override
    public void batchDeleteCode(List<Long> ids) {
        this.getSqlSession().delete(this.getStatement("batchDeleteCode"), ids);
    }

    @Override
    public List<BookAuthCodeDTO> getBookAuthCodeList(Map<String, Object> paramMap) {
        return this.getSessionTemplate().selectList(this.getStatement("getBookAuthCodeList"), paramMap);
    }

    @Override
    public BookAuthCodeDTO getBaseById(Long codeId) {
        return this.getSessionTemplate().selectOne(this.getStatement("getBaseById"), codeId);
    }


}
