package com.pcloud.book.group.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author 戴兴
 * @description TODO
 * @date 2019/3/2 14:12
 */
public class BookGroupClassify extends BaseEntity {

    private static final long serialVersionUID = 6793085343129702487L;

    /**
     * 群标签标识
     */
    private Long id;

    /**
     * 图书标识
     */
    private Long bookId;

    /**
     * 运营标识
     */
    private Long channelId;

    /**
     * 社群二维码标识
     */
    private Long bookGroupId;

    /**
     * 分类
     */
    private String classify;

    /**
     * 分类介绍
     */
    private String classifyIntroduce;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 商品标识
     */
    private Long productId;

    /**
     * 规格标识
     */
    private Long productSpecId;

    /**
     * 换群人数
     */
    private Integer changeNumber;

    /**
     * 排序
     */
    private Integer rank;

    /**
     * 已选书籍列表
     */
    private List<Long> bookGroupIds;

    /**
     * 创建人
     */
    private Long createUser;

    /**
     * 修改用户
     */
    private Long updateUser;

    private Integer isDelete;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date updateTime;

    private Integer currentPage;

    private Integer numPerPage;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public String getClassifyIntroduce() {
        return classifyIntroduce;
    }

    public void setClassifyIntroduce(String classifyIntroduce) {
        this.classifyIntroduce = classifyIntroduce;
    }

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getProductSpecId() {
        return productSpecId;
    }

    public void setProductSpecId(Long productSpecId) {
        this.productSpecId = productSpecId;
    }

    public Integer getChangeNumber() {
        return changeNumber;
    }

    public void setChangeNumber(Integer changeNumber) {
        this.changeNumber = changeNumber;
    }

    public List<Long> getBookGroupIds() {
        return bookGroupIds;
    }

    public void setBookGroupIds(List<Long> bookGroupIds) {
        this.bookGroupIds = bookGroupIds;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getNumPerPage() {
        return numPerPage;
    }

    public void setNumPerPage(Integer numPerPage) {
        this.numPerPage = numPerPage;
    }

    @Override
    public String toString() {
        return "BookGroupClassify{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", bookGroupId=" + bookGroupId +
                ", classify='" + classify + '\'' +
                ", classifyIntroduce='" + classifyIntroduce + '\'' +
                ", price=" + price +
                ", productId=" + productId +
                ", productSpecId=" + productSpecId +
                ", changeNumber=" + changeNumber +
                ", rank=" + rank +
                ", bookGroupIds=" + bookGroupIds +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                ", isDelete=" + isDelete +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", currentPage=" + currentPage +
                ", numPerPage=" + numPerPage +
                '}';
    }
}