package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/17 15:46
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ClassifyQrcodeVO implements Serializable {

    @ApiModelProperty("二维码标识")
    private Long id;

    @ApiModelProperty("分类标识")
    private Long classifyId;

    @ApiModelProperty("群名称")
    private String groupName;

    @ApiModelProperty("换群人数")
    private Integer changeNumber;

    @ApiModelProperty("群人数")
    private Integer userNumber;

    @ApiModelProperty("微信二维码url")
    private String qrcodeUrl;

    @ApiModelProperty("退群率")
    private BigDecimal quitRate;

    @ApiModelProperty("微信群标识")
    private Long weixinQrcodeId;

    @ApiModelProperty("微信群标识")
    private String weixinGroupId;

    @ApiModelProperty("关键词识别次数")
    private Integer keywordCount;

    @ApiModelProperty(value = "二维码状态", hidden = true)
    private Integer qrcodeState;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("关键词识别次数")
    private Date createdTime;

    public String getWeixinGroupId() {
        return weixinGroupId;
    }

    public void setWeixinGroupId(String weixinGroupId) {
        this.weixinGroupId = weixinGroupId;
    }

    public Long getWeixinQrcodeId() {
        return weixinQrcodeId;
    }

    public void setWeixinQrcodeId(Long weixinQrcodeId) {
        this.weixinQrcodeId = weixinQrcodeId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Integer getChangeNumber() {
        return changeNumber;
    }

    public void setChangeNumber(Integer changeNumber) {
        this.changeNumber = changeNumber;
    }

    public Integer getUserNumber() {
        return userNumber;
    }

    public void setUserNumber(Integer userNumber) {
        this.userNumber = userNumber;
    }

    public String getQrcodeUrl() {
        return qrcodeUrl;
    }

    public void setQrcodeUrl(String qrcodeUrl) {
        this.qrcodeUrl = qrcodeUrl;
    }

    public BigDecimal getQuitRate() {
        return quitRate;
    }

    public void setQuitRate(BigDecimal quitRate) {
        this.quitRate = quitRate;
    }

    public Integer getKeywordCount() {
        return keywordCount;
    }

    public void setKeywordCount(Integer keywordCount) {
        this.keywordCount = keywordCount;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    public Date getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Integer getQrcodeState() {
        return qrcodeState;
    }

    public void setQrcodeState(Integer qrcodeState) {
        this.qrcodeState = qrcodeState;
    }

    @Override
    public String toString() {
        return "ClassifyQrcodeVO{" +
                "id=" + id +
                ", classifyId=" + classifyId +
                ", groupName='" + groupName + '\'' +
                ", changeNumber=" + changeNumber +
                ", userNumber=" + userNumber +
                ", qrcodeUrl='" + qrcodeUrl + '\'' +
                ", quitRate=" + quitRate +
                ", weixinQrcodeId=" + weixinQrcodeId +
                ", weixinGroupId='" + weixinGroupId + '\'' +
                ", keywordCount=" + keywordCount +
                ", qrcodeState=" + qrcodeState +
                ", createdTime=" + createdTime +
                '}';
    }
}
