package com.pcloud.book.mq.topic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import com.pcloud.book.consumer.channel.QrcodeSceneConsr;
import com.pcloud.book.group.biz.GroupQrcodeBiz;
import com.pcloud.book.group.biz.WeixinQrcodeBiz;
import com.pcloud.book.group.dto.BookWxQrcodeDTO;
import com.pcloud.book.group.dto.GroupQrcodeServerDTO;
import com.pcloud.book.group.tools.SendWeixinRequestTools;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.channelcenter.wechat.dto.AccountSettingDto;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.httpclient.UrlUtils;
import com.pcloud.liveapp.live.dto.LiveCourseDetailInfoDto;
import com.pcloud.liveapp.live.dto.TableDetailDto;
import com.sdk.wxgroup.SendTextMessageVO;
import com.sdk.wxgroup.WxGroupSDK;

import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
@RabbitListener(queues = MQTopicConumer.WX_LIVE_BROADCAST_REMINDER)
public class WxLiveBroadcastReminderListener {

    @Resource
    private GroupQrcodeBiz groupQrcodeBiz;
    @Resource
    private QrcodeSceneConsr qrcodeSceneConsr;
    @Autowired
    private WeixinQrcodeBiz weixinQrcodeBiz;


    /**
     * 接收微信用户进群消息
     */
    @ParamLog("直播开播提醒")
    @RabbitHandler
    public void onMessage(LiveCourseDetailInfoDto liveCourse) throws BizException {
        if (Objects.isNull(liveCourse) || CollectionUtils.isEmpty(liveCourse.getTableDetailDtos())) {
            return;
        }
        Map<Long, Long> collect = liveCourse.getTableDetailDtos().stream().collect(Collectors.toMap(TableDetailDto::getOriginId, TableDetailDto::getTableId));
        final List<GroupQrcodeServerDTO> wxGroups = groupQrcodeBiz.getWxGroupIdByServerId(Lists.newArrayList(collect.keySet()));
        log.info("[直播开播提醒] : liveCourse :{} wxGroups:{}", liveCourse, wxGroups);
        if (CollectionUtils.isEmpty(wxGroups)) {
            return;
        }
        final Map<Long, AccountSettingDto> accountMap = Maps.newHashMap();
        List<String> wxGroupIds = wxGroups.stream().map(GroupQrcodeServerDTO::getWxGroupId).collect(Collectors.toList());
        Map<String, BookWxQrcodeDTO> groupVersion = weixinQrcodeBiz.getGroupVersion(wxGroupIds);
        final List<GroupQrcodeServerDTO> wxGroups2 = wxGroups.stream().collect(
                Collectors. collectingAndThen(
                        Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(GroupQrcodeServerDTO::getWxGroupId))), ArrayList::new)
        );
        for (GroupQrcodeServerDTO dto : wxGroups2) {
            // 避免重复挂服务调用性能损耗
            AccountSettingDto accountSettingDto = accountMap.get(dto.getChannelId());
            if (Objects.isNull(accountSettingDto)) {
                accountSettingDto = qrcodeSceneConsr.getWechatInfo(dto.getChannelId());
                accountMap.put(dto.getChannelId(), accountSettingDto);
            }
            String linkUrl = SendWeixinRequestTools.splitUrlNew(accountSettingDto, dto.getLinkUrl(), dto.getBookGroupId(), dto.getClassifyId(), dto.getGroupQrcodeId());
            // 定位到具体课程
            String liveInfo = linkUrl.replace("liveinfo?", "lesson/" + liveCourse.getLessonId() + "?tableId=" + collect.get(dto.getServeId()) + "&");
            String shortUrl4Own = UrlUtils.getShortUrl4Own(liveInfo);
            SendTextMessageVO vo = new SendTextMessageVO();
            vo.setContent("【" + liveCourse.getTitle() + "】即将开播啦，感兴趣的同学们可以开始进入啦。猛戳直播链接：" + shortUrl4Own);
            vo.setWxGroupId(dto.getWxGroupId());
            // 负载均衡会根据群获取该群活跃小号，所以传什么都不重要，写死为“我为你笑着”
            vo.setAltId(Optional.ofNullable(groupVersion.get(dto.getWxGroupId())).orElse(new BookWxQrcodeDTO()).getRobotWxId());
            vo.setIp(Optional.ofNullable(groupVersion.get(dto.getWxGroupId())).orElse(new BookWxQrcodeDTO()).getWechatGroupIp());
            WxGroupSDK.sendTextMessage(vo);
        }
    }
}
