package com.pcloud.book.advertising.check;

import com.pcloud.book.advertising.dto.BrandDataAddDTO;
import com.pcloud.book.advertising.dto.BrandDataParamDTO;
import com.pcloud.book.advertising.enums.BrandDataFromTypeEnum;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @描述：品牌方数据校验
 * @作者：zhuyajie
 * @创建时间：14:04 2020/4/16
 * @版本：1.0
 */

@Component
public class BrandDataCheck {

    /**
     * 添加参数校验
     * @param brandDataParamDTO
     */
    public void checkAddData(BrandDataParamDTO brandDataParamDTO) {
        if (null == brandDataParamDTO){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数为空！");
        }
        if (StringUtil.isEmpty(brandDataParamDTO.getFromType())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "来源类型为空！");
        }
        String fromType=brandDataParamDTO.getFromType();
        //书刊
        if (BrandDataFromTypeEnum.BOOK.value.equals(fromType)){
            if (null==brandDataParamDTO.getBookId() || null==brandDataParamDTO.getChannelId()
                    || null==brandDataParamDTO.getAdviserId()){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "书刊参数有误！");
            }
            brandDataParamDTO.setSceneId(null);
            brandDataParamDTO.setServeId(null);
        }
        //二维码
        if (BrandDataFromTypeEnum.QRCODE.value.equals(fromType)){
            if (null == brandDataParamDTO.getSceneId()){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "二维码参数有误！");
            }
            brandDataParamDTO.setServeId(null);
        }
        //应用、作品
        if (BrandDataFromTypeEnum.APP.value.equals(fromType)||BrandDataFromTypeEnum.PRODUCT.value.equals(fromType)){
            if (null==brandDataParamDTO.getSceneId()){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "二维码参数有误！");
            }
            if (null==brandDataParamDTO.getServeId()){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "资源服务参数有误！");
            }
        }
        //数据类型
        if (ListUtils.isEmpty(brandDataParamDTO.getDataAddDTOS())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "数据列表有误！");
        }
        for (BrandDataAddDTO dataAddDTO: brandDataParamDTO.getDataAddDTOS()){
            if (null==dataAddDTO){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数为空！");
            }
            if (StringUtil.isEmpty(dataAddDTO.getAddType())){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "数据类型参数为空！");
            }
            dataAddDTO.setAddCount(dataAddDTO.getAddCount()==null?0:dataAddDTO.getAddCount());
        }
    }


}
