package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletBooklistDTO;
import com.pcloud.book.applet.dto.BookDTO4Booklist;
import com.pcloud.book.applet.entity.AppletBooklist;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

public interface AppletBooklistDao extends BaseDao<AppletBooklist> {

    /**
     * 删除书单配置
     *
     * @param booklistId
     */
    void deleteConfigByBooklistId(Long booklistId);

    /**
     * 添加书单配置
     *
     * @param bookDTO4Booklists
     */
    void addBooklistConfig(List<BookDTO4Booklist> bookDTO4Booklists);

    /**
     * 根据栏目id查询
     * @param classifyId
     * @return
     */
    List<AppletBooklist> getByClassifyId(Long classifyId);

    /**
     * 更新书籍排序
     * @param configId
     * @param seq
     */
    void updateBookSeq(Long configId, Integer seq);

    /**
     * 查配置书籍（书名、封面）
     * @param booklistId
     * @return
     */
    List<BookDTO4Booklist> getBookBaseByBooklistId(Long booklistId, Integer currentPage, Integer numPerPage);

    /**
     * 查配置书籍（包含书籍分类）
     * @param booklistId
     * @return
     */
    List<BookDTO4Booklist> listPageBook4AppletBooklist(Long booklistId);

    /**
     * 基本配置（adviserid bookid channelid）
     * @param booklistIds
     * @return
     */
    List<BookDTO4Booklist> getConfigByBooklistIds(List<Long> booklistIds);

    /**
     * 图书详情-出版作者分类书名
     * @param adviserId
     * @param channelId
     * @param bookId
     * @return
     */
    BookDTO4Booklist getByBookIdAdviserChannel(Long adviserId, Long channelId, Long bookId);

    /**
     * 根据分类查询书单
     * @author：zhuyajie
     * @date：2020/8/10 10:37
     *  * @param null
     */
    List<AppletBooklistDTO> getByLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Integer limit);




    /**
     * 更新删除状态
     * @param id
     */
    void updateDeleteState(Long id);

    /**
     * 获取小程序书单
     * @param bookListIds
     * @return
     */
    Map<Long, AppletBooklistDTO> getBookListMap(List<Long> bookListIds);
}
