package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletBooklistDao;
import com.pcloud.book.applet.dto.AppletBooklistDTO;
import com.pcloud.book.applet.dto.BookDTO4Booklist;
import com.pcloud.book.applet.entity.AppletBooklist;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("appletBooklistDao")
public class AppletBooklistDaoImpl extends BaseDaoImpl<AppletBooklist> implements AppletBooklistDao {

    @Override
    public void deleteConfigByBooklistId(Long booklistId) {
        getSessionTemplate().delete(getStatement("deleteConfigByBooklistId"), booklistId);
    }

    @Override
    public void addBooklistConfig(List<BookDTO4Booklist> bookDTO4Booklists) {
        getSessionTemplate().insert(getStatement("addBooklistConfig"), bookDTO4Booklists);
    }

    @Override
    public List<AppletBooklist> getByClassifyId(Long classifyId) {
        return getSessionTemplate().selectList(getStatement("getByClassifyId"), classifyId);
    }

    @Override
    public void updateBookSeq(Long configId, Integer seq) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", configId);
        map.put("seq", seq);
        getSessionTemplate().update(getStatement("updateBookSeq"), map);
    }

    @Override
    public List<BookDTO4Booklist> getBookBaseByBooklistId(Long booklistId, Integer currentPage, Integer numPerPage) {
        Map<String, Object> map = new HashMap<>();
        map.put("booklistId", booklistId);
        if (currentPage>=0 && numPerPage>0){
            map.put("pageNum", currentPage * numPerPage);
            map.put("numPerPage", numPerPage);
        }
        return getSessionTemplate().selectList(getStatement("getBookBaseByBooklistId"),map);
    }

    @Override
    public List<BookDTO4Booklist> listPageBook4AppletBooklist(Long booklistId) {
        Map<String, Object> map = new HashMap<>();
        map.put("booklistId", booklistId);
        return getSessionTemplate().selectList(getStatement("listPageBook4AppletBooklist"), map);
    }

    @Override
    public List<BookDTO4Booklist> getConfigByBooklistIds(List<Long> booklistIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("list", booklistIds);
        return getSessionTemplate().selectList(getStatement("getConfigByBooklistIds"),map);
    }

    @Override
    public BookDTO4Booklist getByBookIdAdviserChannel(Long adviserId, Long channelId, Long bookId) {
        Map<String, Object> map = new HashMap<>();
        map.put("adviserId", adviserId);
        map.put("channelId", channelId);
        map.put("bookId", bookId);
        return getSessionTemplate().selectOne(getStatement("getByBookIdAdviserChannel"),map);
    }

    @Override
    public List<AppletBooklistDTO> getByLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Integer limit) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("firstClassify", firstClassify);
        paramMap.put("secondClassify", secondClassify);
        paramMap.put("gradeLabelId", gradeLabelId);
        paramMap.put("subjectLabelId", subjectLabelId);
        paramMap.put("limit", limit);
        return getSessionTemplate().selectList(getStatement("getByLabel"), paramMap);
    }


    @Override
    public void updateDeleteState(Long id) {
        getSessionTemplate().update(getStatement("updateDeleteState"), id);
    }

    @Override
    public Map<Long, AppletBooklistDTO> getBookListMap(List<Long> bookListIds) {
        return getSessionTemplate().selectMap(getStatement("getBookListMap"),bookListIds,"id");
    }
}
