package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletRecordDao;
import com.pcloud.book.applet.dto.AppletRecordDTO;
import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.entity.AppletRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * (AppletRecord)表数据库访问层
 *
 * @author makejava
 * @since 2020-08-27 15:49:56
 */
@Repository("appletRecordDaoImpl")
public class AppletRecordDaoImpl extends BaseDaoImpl<AppletRecord> implements AppletRecordDao {

    @Override
    public Map<Long, AppletUserBookcaseDTO> getBookMap(List<AppletRecordDTO> appletRecordDTOS4Book) {
        return getSessionTemplate().selectMap(getStatement("getBookMap"), appletRecordDTOS4Book, "id");
    }

    @Override
    public void updateDeleteState(Long fromId, Integer recordType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("fromId", fromId);
        paramMap.put("recordType", recordType);
        getSessionTemplate().update(getStatement("updateDeleteState"), paramMap);
    }
}