/**
 *
 */
package com.pcloud.book.book.facade;

import com.pcloud.book.base.dto.CountDto;
import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.book.book.dto.BookCountDto;
import com.pcloud.book.book.dto.BookDataStatisticsDTO;
import com.pcloud.book.book.dto.BookQrcodeStatisticsDTO;
import com.pcloud.book.book.dto.BookResourceStatisticsDTO;
import com.pcloud.book.book.dto.MapResourceTotalCountDTO;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.*;
import org.codehaus.jackson.JsonParseException;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @描述：编辑推广书籍接口类
 * @作者：songx
 * @创建时间：2016年12月30日,下午6:02:15 @版本：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookAdviserFacadeCloud", path = "book/v1.0/bookAdviser")
@Api(description = "顾问书籍管理外部服务")
public interface BookAdviserFacade {

    /**
     * 创建编辑和书籍推广关系
     *
     * @param token
     * @param bookAdviser
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "创建编辑和书籍推广关系", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookAdviser", value = "编辑书籍关系实体", dataType = "BookAdviser", paramType = "body")})
    @RequestMapping(value = "create", method = RequestMethod.POST)
    public ResponseDto<BookAdviserDto> create(@RequestHeader("token") String token,
                                              @RequestBody BookAdviser bookAdviser) throws BizException, PermissionException, JsonParseException;

    /**
     * @param token
     * @param bookId
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     * @Title: getAdviserList
     * @Description:编辑管理--获取编辑列表（平台端）
     * @return: ResponseDto<PageBean>
     * @author: lihao
     * @date: 2017年7月12日 上午10:45:17
     */
    @ApiOperation(value = "编辑管理--获取编辑列表（平台端）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "listAdviser", method = RequestMethod.GET)
     ResponseDto<?> getAdviserList(@RequestHeader("token") String token,
                                         @RequestParam(value = "bookId", required = false) Long bookId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * @param token
     * @param bookAdvisers
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     * @Title: delViceAdviser
     * @Description:编辑管理--删除副编辑
     * @return: ResponseDto<?>
     * @author: lihao
     * @date: 2017年7月12日 下午5:23:48
     */
    @RequestMapping(value = "batDelViceAdviser", method = RequestMethod.POST)
    public ResponseDto<?> delViceAdviser(@RequestHeader("token") String token,
                                         @RequestBody @ApiParam List<BookAdviser> bookAdvisers)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 编辑 - 是否有默认Ray纸书
     *
     * @param token
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "编辑 - 是否有默认Ray纸书", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getDefaultBook", method = RequestMethod.GET)
    ResponseDto<?> getDefaultBook(@RequestHeader("token") String token,
                                  @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 出版社下编辑的所有书刊的数目
     *
     * @param token
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "出版社下编辑的所有书刊的数目", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header")})
    @RequestMapping(value = "getBookCount", method = RequestMethod.GET)
    ResponseDto<CountDto> getBookCount(@RequestHeader("token") String token)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 每日新增图书数-出版
     *
     * @param token
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "每日新增图书数-出版", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header")})
    @RequestMapping(value = "listBookCountByDate4Agent", method = RequestMethod.GET)
    ResponseDto<List<BookCountDto>> listBookCountByDate4Agent(@RequestHeader("token") String token)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 删除书籍（编辑端）
     *
     * @param token
     * @param channelId
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "删除书籍（编辑端）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "deleteBook4Adviser", method = RequestMethod.GET)
    ResponseDto<?> deleteBook4Adviser(@RequestHeader("token") String token,
                                      @RequestParam("bookId") Long bookId,
                                      @RequestParam("channelId") Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 回收站恢复
     *
     * @param token
     * @param bookId
     * @param channelId
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "回收站恢复（编辑端）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "deleteBook4Adviser", method = RequestMethod.GET)
    ResponseDto<?> recoverBook4Adviser(@RequestHeader("token") String token,
                                       @RequestParam(value = "bookId", required = false) Long bookId,
                                       @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

	/**
	 * 获取编辑的图书总数
	 *
	 * @param token
	 * @return
	 * @throws PermissionException
	 * @throws JsonParseException
	 * @throws BizException
	 */
	@ApiOperation(value = "获取编辑的图书总数", httpMethod = "GET")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header") })
	@RequestMapping(value = "getAdviserBookCount", method = RequestMethod.GET)
	ResponseDto<CountDto> getAdviserBookCount(@RequestHeader("token") String token)
			throws PermissionException, JsonParseException, BizException;

    @ApiOperation(value = "获取编辑书刊列表(ERP项目用)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "uniqueNumber", value = "uniqueNumber", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "adviserName", value = "adviserName", dataType = "string", paramType = "query")})
    @RequestMapping(value = "listAdviserBook4Erp", method = RequestMethod.GET)
    ResponseDto<?> listAdviserBook4Erp(@RequestHeader("token") String token,
                                              @RequestParam(value = "isbn", required = false) String isbn,
                                              @RequestParam(value = "uniqueNumber", required = false) String uniqueNumber,
                                              @RequestParam(value = "adviserName", required = false) String adviserName,
                                              @RequestParam(value = "currentPage") Integer currentPage,
                                              @RequestParam(value = "numPerPage") Integer numPerPage)
            throws PermissionException, JsonParseException, BizException;

    /**
     * 设置书刊是否已下印状态
     * @param token
     * @param bookAdviser
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "设置书刊是否已下印状态", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookAdviser", value = "编辑书籍关系实体", dataType = "BookAdviser", paramType = "body")
    })
    @RequestMapping(value = "setIsPrint", method = RequestMethod.POST)
    ResponseDto<?> setIsPrint(@RequestHeader("token") String token,
            @RequestBody BookAdviser bookAdviser) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("获取书下资源总数（包括现代纸书、1V1、小睿、社群码）")
    @PostMapping("mapResourceTotalCount")
    ResponseDto<Map<String, BookResourceStatisticsDTO>> mapResourceTotalCount(@RequestBody MapResourceTotalCountDTO mapResourceTotalCountDTO);

    @ApiOperation("获取书刊统计数据（用户数、扫码量）")
    @PostMapping("mapBookDataStatistics")
    ResponseDto<Map<String, BookDataStatisticsDTO>> mapBookDataStatistics(@RequestBody MapResourceTotalCountDTO mapResourceTotalCountDTO);

    @ApiOperation("获取书刊二维码统计数据")
    @PostMapping("mapBookQrcodeStatistics")
    ResponseDto<Map<String, BookQrcodeStatisticsDTO>> mapBookQrcodeStatistics(@RequestBody MapResourceTotalCountDTO mapResourceTotalCountDTO);

    @ApiOperation("小睿数据看板-书刊品种数")
    @GetMapping("getRayBookCountAndRate")
    ResponseDto<?> getRayBookCountAndRate(@RequestParam(value = "showRate", defaultValue = "false") Boolean showRate);

}
