package com.pcloud.book.group.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/9/24 15:16
 **/
@ApiModel("社群书暗号关联用户")
public class BookGroupCipherUser extends BaseEntity {
    private static final long serialVersionUID = 1763812276337850708L;

    @ApiModelProperty("社群码id")
    private Long bookGroupId;

    @ApiModelProperty("社群码暗号")
    private String bookGroupCipher;

    @ApiModelProperty("用户微信id")
    private String wxUserId;

    @ApiModelProperty("机器人id")
    private String altId;

    @ApiModelProperty("书籍简称")
    private String shortBookName;

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public String getBookGroupCipher() {
        return bookGroupCipher;
    }

    public void setBookGroupCipher(String bookGroupCipher) {
        this.bookGroupCipher = bookGroupCipher;
    }

    public String getWxUserId() {
        return wxUserId;
    }

    public void setWxUserId(String wxUserId) {
        this.wxUserId = wxUserId;
    }

    public String getAltId() {
        return altId;
    }

    public void setAltId(String altId) {
        this.altId = altId;
    }

    public String getShortBookName() {
        return shortBookName;
    }

    public void setShortBookName(String shortBookName) {
        this.shortBookName = shortBookName;
    }

    @Override
    public String toString() {
        return "BookGroupCipherUser{" +
                "bookGroupId=" + bookGroupId +
                ", bookGroupCipher='" + bookGroupCipher + '\'' +
                ", wxUserId='" + wxUserId + '\'' +
                ", altId='" + altId + '\'' +
                ", shortBookName='" + shortBookName + '\'' +
                "} " + super.toString();
    }
}
