package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * (AppletSubscribeCount)实体类
 *
 * @author wubo
 * @since 2021-08-09 10:54:38
 */
@Data
public class AppletSubscribeCount extends BaseEntity {

    private static final long serialVersionUID = -91920484989934172L;

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("用户id")
    private Long wechatUserId;

    @ApiModelProperty("记录类型 1 消息未读提醒  2 主人召回提醒")
    private Integer recordType;

    @ApiModelProperty("可用次数")
    private Integer validCount;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}