package com.pcloud.book.applet.mapper;

import com.pcloud.book.applet.entity.AppletBookScoreSubTag;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 小程序本书服务评价二级标签表(AppletBookScoreSubTag)表数据库访问层
 *
 * @author guiq
 * @since 2021-02-20 15:26:56
 */
@Mapper
@Component
public interface AppletBookScoreSubTagMapper {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletBookScoreSubTag queryById(Integer id);

    /**
     * 查询指定行数据
     *
     * @param offset 查询起始位置
     * @param limit  查询条数
     * @return 对象列表
     */
    List<AppletBookScoreSubTag> queryAllByLimit(@Param("offset") int offset, @Param("limit") int limit);


    /**
     * 通过实体作为筛选条件查询
     *
     * @param appletBookScoreSubTag 实例对象
     * @return 对象列表
     */
    List<AppletBookScoreSubTag> queryAll(AppletBookScoreSubTag appletBookScoreSubTag);

    /**
     * 新增数据
     *
     * @param appletBookScoreSubTag 实例对象
     * @return 影响行数
     */
    int insert(AppletBookScoreSubTag appletBookScoreSubTag);

    /**
     * 批量新增数据（MyBatis原生foreach方法）
     *
     * @param entities List<AppletBookScoreSubTag> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<AppletBookScoreSubTag> entities);

    /**
     * 批量新增或按主键更新数据（MyBatis原生foreach方法）
     *
     * @param entities List<AppletBookScoreSubTag> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<AppletBookScoreSubTag> entities);

    /**
     * 修改数据
     *
     * @param appletBookScoreSubTag 实例对象
     * @return 影响行数
     */
    int update(AppletBookScoreSubTag appletBookScoreSubTag);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Integer id);

}

