package com.pcloud.book.book.facade;

import com.pcloud.book.book.biz.BookCoverBiz;
import com.pcloud.book.book.dto.BookCoverDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController("bookCover")
@RequestMapping("/bookCover")
@Api(description = "图书封面服务")
public class BookCoverFacade {
    @Autowired
    private BookCoverBiz bookCoverBiz;

    @ApiOperation(value = "根据分类ID获取封面", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "templetId", value = "分类ID", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页号", dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页显示数目", dataType = "Integer", paramType = "query")})
    @RequestMapping(value = "/getCoverByTempletId", method = RequestMethod.GET)
    public ResponseDto<PageBeanNew<BookCoverDTO>> getCoverByTempletId(
            @RequestHeader("token") String token,
            @RequestParam(value = "templetId", required = false) Long templetId,
            @RequestParam(value = "currentPage") Integer currentPage,
            @RequestParam(value = "numPerPage") Integer numPerPage,
            @RequestParam(value = "bookLabelId", required = false) Long bookLabelId) {
        SessionUtil.getVlaue(token, SessionUtil.USER_ID);
        return new ResponseDto<>(bookCoverBiz.getCoverByTempletId(templetId, currentPage, numPerPage, bookLabelId));
    }

    @ApiOperation("添加封面")
    @RequestMapping(value ="insert", method = RequestMethod.GET)
    public ResponseDto<BookCoverDTO> insert(@RequestHeader("token") String token,
            @RequestParam(value = "templetId", required = false) Long templetId,
            @RequestParam(value = "coverImg") String coverImg) {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(bookCoverBiz.addCover(templetId, coverImg));
    }

    @ApiOperation("删除封面")
    @RequestMapping(value = "delete", method = RequestMethod.GET)
    public ResponseDto<?> delete(@RequestHeader("token") String token,
            @RequestParam(value = "coverId") String coverId) {
        SessionUtil.getToken4Redis(token);
        bookCoverBiz.deleteCoverById(coverId);
        return new ResponseDto<>();
    }

    @ApiOperation("更新封面")
    @RequestMapping(value ="update", method = RequestMethod.GET)
    public ResponseDto<?> update(@RequestHeader("token") String token,
            @RequestParam(value = "templetId") Long templetId,
            @RequestParam(value = "coverId") String coverId,
            @RequestParam(value = "coverImg") String coverImg) {
        SessionUtil.getToken4Redis(token);
        bookCoverBiz.updateCover(templetId, coverImg,coverId);
        return new ResponseDto<>();
    }

}

