package com.pcloud.book.consumer.user;

import com.pcloud.book.applet.contants.AppletConstants;
import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.util.common.CommonUtils;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import com.pcloud.resourcecenter.base.constants.ResourceRedisCons;
import com.pcloud.usercenter.party.merchant.service.MerchantService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import cn.hutool.core.collection.CollUtil;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/11/14 16:42
 **/
@Component("merchantConsr")
public class MerchantConsr {

    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(MerchantConsr.class);

    @Autowired
    private MerchantService merchantService;

    /**
     * 批量获取作者名称
     */
    public Map<Long, String> getNamesByIdList(List<Long> merchantIds) throws BizException {
        LOGGER.info("批量获取作者名称,<START>.[merchantIds]=" + merchantIds.toString());
        if (ListUtils.isEmpty(merchantIds)) {
            return null;
        }
        Map<Long, String> map = null;
        try {
            map = ResponseHandleUtil.parseMapResponse(merchantService.getNamesByIdList(merchantIds), Long.class,
                    String.class);
        } catch (Exception e) {
            LOGGER.error("批量获取作者名称,<ERROR>.[getNamesByIdList]:" + e.getMessage(), e);
        }
        return map;
    }


    /**
     * 批量获取作者名称
     */
    public Map<Long, Long> getSuperMerchantList() throws BizException {
        Map<Long, Long> map = null;
        try {
            map = ResponseHandleUtil.parseMapResponse(merchantService.getSuperMerchantList(), Long.class, Long.class);
        } catch (Exception e) {
            LOGGER.error("获取所有超级作者,<ERROR>.[getSuperMerchantList]:" + e.getMessage(), e);
        }
        return map;
    }

    public List<Long> getSuperMerchantIdList() throws BizException {
        List<Long> result = null;
        try {
            result = JedisClusterUtils.getJsonList(BookConstant.SUPER_MERCHANT_LIST, Long.class);
            if(CollUtil.isEmpty(result)){
                Map<Long, Long> map = ResponseHandleUtil.parseMapResponse(merchantService.getSuperMerchantList(), Long.class, Long.class);
                result = CollUtil.isEmpty(map) ? new ArrayList<>()
                        : new ArrayList<>(map.keySet());
                JedisClusterUtils.setJsonList(BookConstant.SUPER_MERCHANT_LIST, result,
                        CommonUtils.todayRemainingSeconds());
            }
        } catch (Exception e) {
            LOGGER.error("获取所有超级作者id,<ERROR>.[getSuperMerchantList]:" + e.getMessage(), e);
        }
        return result;
    }
}
