package com.pcloud.book.copyright.biz;

import com.pcloud.book.copyright.dto.BookAuthInfoCountDTO;
import com.pcloud.book.copyright.dto.BookAuthTotalCountDTO;
import com.pcloud.book.copyright.vo.AuthOpenVO;
import com.pcloud.book.copyright.vo.BookAuthInfoAndServesVO;
import com.pcloud.book.copyright.vo.BookAuthInfoVO;
import com.pcloud.book.copyright.vo.BookAuthInfoWechatVO;
import com.pcloud.book.copyright.vo.GetAuthInfoParam;
import com.pcloud.book.copyright.vo.ListHaveAuthBookParam;
import com.pcloud.book.copyright.vo.ListHaveAuthGroupBookParam;
import com.pcloud.book.copyright.vo.SetAuthStatusParam;
import com.pcloud.book.copyright.vo.SetAuthOpenParam;
import com.pcloud.book.copyright.vo.SetLocationDescVO;
import com.pcloud.common.page.PageBeanNew;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lily
 * @date 2018/12/3 11:39
 */
public interface BookAuthInfoBiz {

    /**
     * 设置图书版权开启
     */
    void setBookAuthOpen(SetAuthOpenParam setAuthOpenParam, Long adviserId);

    void sendLetter(Long adviserId, String bookName, String url, String commitTime);

    /**
     * 设置授权后付费查看
     */
    void setBookAuthPay(SetAuthStatusParam setAuthStatusParam, Long adviserId);

    /**
     * 设置图书版权状态
     */
    void setAuthStatus(SetAuthStatusParam setAuthStatusParam, Long adviserId);

    /**
     * 设置图书位置描述
     */
    void setBookLocationDesc(SetLocationDescVO setLocationDesc, Long adviserId);

    /**
     * 是否有正版授权图书
     */
    Boolean getIsHaveAuthBook(Long adviserId);

    /**
     *  获取图书正版授权基本信息
     */
    BookAuthInfoVO getInfoByBook(Long bookId, Long channelId, Long adviserId, Integer authBookType);

    /**
     *  获取图书正版授权基本信息
     */
    BookAuthInfoAndServesVO getInfoAndServesByBook(Long bookId, Long channelId, Long adviserId, Integer authBookType);

    /**
     * 获取设置够正版授权图书信息
     * @return
     */
    PageBeanNew listHaveSetAuthBook(ListHaveAuthBookParam listHaveAuthBookParam, Long adviserId);

    /**
     * 获取设置够正版授权社群书信息
     * @return
     */
    PageBeanNew listHaveSetAuthGroupBook(ListHaveAuthGroupBookParam listHaveAuthGroupBookParam, Long adviserId);

    /**
     * 获取正版授权金价格
     */
    BigDecimal getBookAuthPrice(Long bookId, Long channelId, Long adviserId, Integer authBookType);

    /**
     * 获取图书授权信息
     */
    BookAuthInfoWechatVO getInfoByBook4Wechat(GetAuthInfoParam getAuthInfoParam, Long channelId);

    /**
     * 获取图书授权基本信息
     */
    BookAuthInfoVO getAuthBookInfo(Long bookId, Long channelId, Long adviserId, Long sceneId, Integer authBookType);

    /**
      * 获取图书授权统计
     */
    BookAuthInfoCountDTO getBookAuthInfoCount(Long bookId, Long channelId, Long adviserId, String monthDate);

    /**
     * 获取图书授权总的提示
     */
    BookAuthTotalCountDTO getBookAuthTotalCount(List<Long> adviserIds);

    /**
     * 获取是否有正在导出的
     */
    Boolean isHaveExport(Long bookId, Long channelId, Long adviserId);

    /**
     *  升级版权保护
     */
    void setBookCodeAuth(AuthOpenVO authOpenVO, Long adviserId);
}
