package com.pcloud.book.copyright.dao.impl;

import com.pcloud.book.copyright.dao.BookExportRecordDao;
import com.pcloud.book.copyright.entity.BookExportRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/4 19:20
 */
@Component("bookExportRecordDao")
public class BookExportRecordDaoImpl extends BaseDaoImpl<BookExportRecord> implements BookExportRecordDao {

    @Override
    public void updateRecordStatus(BookExportRecord bookExportRecord) {
        this.getSqlSession().update(this.getStatement("updateRecordStatus"), bookExportRecord);
    }

    @Override
    public Boolean isHaveExport(Long bookId, Long channelId, Long adviserId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        return this.getSqlSession().selectOne(this.getStatement("isHaveExport"), paramMap);
    }

    @Override
    public void updateRecord(BookExportRecord bookExportRecord) {
        this.getSqlSession().update(this.getStatement("updateRecord"), bookExportRecord);
    }

    @Override
    public void handleExportFail() {
        this.getSqlSession().update(this.getStatement("handleExportFail"));
    }

    @Override
    public String getExportUrl(Long bookId, Long channelId, Long adviserId, Long sceneId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("sceneId",sceneId);
        return this.getSqlSession().selectOne(this.getStatement("getExportUrl"), paramMap);
    }
}
