package com.pcloud.book.copyright.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 书籍二维码授权码记录表(BookSceneAuthCode)实体类
 *
 * @author makejava
 * @since 2021-10-19 14:14:47
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookSceneAuthCode extends BaseEntity {

    private static final long serialVersionUID = 501026115036847009L;
    
    @ApiModelProperty("主键标识")
    private Long id;
    
    @ApiModelProperty("图书标识")
    private Long bookId;
    
    @ApiModelProperty("二维码id")
    private Long sceneId;
    
    @ApiModelProperty("运营标识")
    private Long channelId;
    
    @ApiModelProperty("编辑标识")
    private Long adviserId;
    
    @ApiModelProperty("授权码")
    private String authCode;
    
    @ApiModelProperty("批次号")
    private String batchNum;
    
    @ApiModelProperty("完整校验码")
    private String fullCode;
    
    @ApiModelProperty("使用次数")
    private Integer useCount;
    
    @ApiModelProperty("创建方式(0-自动/1-手动)")
    private Integer createType;
    
    @ApiModelProperty("创建人")
    private Long createdUser;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createdDate;
    
    @ApiModelProperty("最后修改人")
    private Long lastModifiedUser;
    
    @ApiModelProperty("最后更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastModifiedDate;
    
    @ApiModelProperty("是否是现代纸书")
    private Integer isPaperBook;
    
    @ApiModelProperty("是否是社群书")
    private Integer isGroupBook;

    private String url;

    private String qrcodeUrl;
    
}