package com.pcloud.book.es.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.pcloud.book.elasticsearch7.domain.dto.param.BookGroupQrcodeSearchDto;
import com.pcloud.book.elasticsearch7.domain.entity.Es7BookGroupQrcode;
import com.pcloud.book.elasticsearch7.service.Es7BookGroupQrcodeService;
import com.pcloud.book.es.biz.ESBookGroupQrcodeBiz;
import com.pcloud.book.es.dto.ESBookGroupQrcodeDTO;
import com.pcloud.book.es.dto.GroupQrcodeSearchDTO;
import com.pcloud.book.group.dao.GroupQrcodeDao;
import com.pcloud.book.group.entity.GroupQrcode;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.universe.commons.paging.Pagination;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author guiq
 * @version 1.0
 * @since 2020年7月10日
 */
@Component("esBookGroupQrcodeBiz")
@Slf4j
public class ESBookGroupQrcodeBizImpl implements ESBookGroupQrcodeBiz {

    @Autowired
    private Es7BookGroupQrcodeService es7BookGroupQrcodeService;
    @Autowired
    private GroupQrcodeDao groupQrcodeDao;

    @Override
    public List<ESBookGroupQrcodeDTO> searchByWxGroupIds(List<String> wxGroupIds) {
        List<ESBookGroupQrcodeDTO> result = new ArrayList<>();
        List<Es7BookGroupQrcode> list = es7BookGroupQrcodeService.findByWxGroupIds(wxGroupIds);
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        list.forEach(bgq -> result.add(convert(bgq)));
        return result;
    }

    @Override
    public void save(List<ESBookGroupQrcodeDTO> dtos) {
        if (CollectionUtils.isNotEmpty(dtos)) {
            List<Es7BookGroupQrcode> qrcodes = new ArrayList<>();
            dtos.forEach(dto -> qrcodes.add(convert(dto)));
            es7BookGroupQrcodeService.save(qrcodes);
        }
    }

    @Override
    public PageBeanNew<GroupQrcodeSearchDTO> search(String text, String methodType, Boolean isOrder, Integer pageSize, Integer pageNum) {

        BookGroupQrcodeSearchDto dto = new BookGroupQrcodeSearchDto();
        dto.setText(text);
        dto.setMethodType(methodType);
        dto.setOrder(isOrder);
        dto.setPageSize(pageSize);
        dto.setCurrentPage(pageNum + 1);
        Pagination<Es7BookGroupQrcode> data = es7BookGroupQrcodeService.search(dto);

        List<GroupQrcodeSearchDTO> list = convert(data.getList());

        return new PageBeanNew<>(pageNum, pageSize, (int) data.getTotalCount(), list);
    }

    private static final BeanCopier BOOK_GROUP_QRCODE_COPIER = BeanCopier.create(Es7BookGroupQrcode.class, ESBookGroupQrcodeDTO.class, false);

    private ESBookGroupQrcodeDTO convert(Es7BookGroupQrcode q) {
        ESBookGroupQrcodeDTO dto = new ESBookGroupQrcodeDTO();
        BOOK_GROUP_QRCODE_COPIER.copy(q, dto, null);
        dto.setId(Long.parseLong(q.getId()));

        return dto;
    }

    private static final BeanCopier BOOK_GROUP_QRCODE_COPIER2 = BeanCopier.create(ESBookGroupQrcodeDTO.class, Es7BookGroupQrcode.class, false);

    private Es7BookGroupQrcode convert(ESBookGroupQrcodeDTO dto) {
        Es7BookGroupQrcode q = new Es7BookGroupQrcode();
        BOOK_GROUP_QRCODE_COPIER2.copy(dto, q, null);
        q.setId(String.valueOf(dto.getId()));

        return q;
    }

    private List<GroupQrcodeSearchDTO> convert(List<Es7BookGroupQrcode> content) {
        if (CollUtil.isEmpty(content)){
            return new ArrayList<>();
        }

        List<GroupQrcodeSearchDTO> list = new ArrayList<>(content.size());
        for (Es7BookGroupQrcode esBookGroupQrcode : content) {
            GroupQrcodeSearchDTO groupQrcodeSearchDTO = new GroupQrcodeSearchDTO();
            if (CollUtil.isNotEmpty(content)){
                BeanUtil.copyProperties(esBookGroupQrcode,groupQrcodeSearchDTO);
                groupQrcodeSearchDTO.setPayMemberCount(esBookGroupQrcode.getAmountActuallyPaid() == null ? 0 : Math.toIntExact(esBookGroupQrcode.getAmountActuallyPaid()));
                if (StrUtil.isEmpty(esBookGroupQrcode.getPurchaseAmount())){
                    groupQrcodeSearchDTO.setPurchaseAmount(BigDecimal.ZERO);
                }else {
                    groupQrcodeSearchDTO.setPurchaseAmount(new BigDecimal(esBookGroupQrcode.getPurchaseAmount()));
                }
                GroupQrcode qrcode = groupQrcodeDao.getById(Long.parseLong(esBookGroupQrcode.getId()));
                if (qrcode!=null&&qrcode.getQrcodeUrl()!=null){
                    groupQrcodeSearchDTO.setQrcodeUrl(qrcode.getQrcodeUrl());
                }
            }
            list.add(groupQrcodeSearchDTO);
        }
        return list;
    }
}
