package com.pcloud.book.es.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 群二维码搜索结果封装
 *
 * @author guiq
 * @version 1.0
 * @since 2020年7月16日
 */
@Data
@ApiModel("群二维码搜索结果封装")
public class GroupQrcodeSearchDTO {

    @ApiModelProperty("book_group_qrcode.id")
    private Long id;
    @ApiModelProperty("群名称")
    private String groupName;
    @ApiModelProperty("群成员人数")
    private Integer groupMemberCount;
    @ApiModelProperty("群付费人数")
    private Integer payMemberCount;
    @ApiModelProperty("付费总额")
    private BigDecimal purchaseAmount;
    @ApiModelProperty("订单总量")
    private Integer purchaseVolume;
    @ApiModelProperty("书名")
    private String qrcodeBookName;
    @ApiModelProperty("ISBN")
    private String isbn;
    @ApiModelProperty("编辑")
    private String adviserName;
    @ApiModelProperty("出版社")
    private String agentName;
    @ApiModelProperty("男性人数")
    private Integer maleCount;
    @ApiModelProperty("女性人数")
    private Integer femaleCount;
    @ApiModelProperty("未知性别人数")
    private Integer unknownCount;
    @ApiModelProperty("成员城市标签")
    private List<String> cityTags;
    @ApiModelProperty("群名称标签")
    private List<String> groupNameTags;
    @ApiModelProperty("书名标签")
    private List<String> bookNameTags;
    @ApiModelProperty("出版社城市")
    private List<String> pressTags;
    @ApiModelProperty("群二维码")
    private String qrcodeUrl;

}
