package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.BookGroupAppDao;
import com.pcloud.book.group.dto.BookGroupAppDTO;
import com.pcloud.book.group.dto.BookGroupIdAndCountDTO;
import com.pcloud.book.group.entity.BookGroupApp;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/11/13 16:50
 **/
@Component("bookGroupAppDao")
public class BookGroupAppDaoImpl extends BaseDaoImpl<BookGroupApp> implements BookGroupAppDao {
    @Override
    public Integer batchInsert(List<BookGroupApp> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public BookGroupApp getByCondition(BookGroupApp bookGroupApp) {
        Map<String, Object> map = new HashMap<>();
        map.put("serveId", bookGroupApp.getServeId());
        map.put("serveType", bookGroupApp.getServeType());
        map.put("bookGroupId", bookGroupApp.getBookGroupId());
        map.put("classifyId", bookGroupApp.getClassifyId());
        map.put("originType", bookGroupApp.getOriginType());
        return super.getSqlSession().selectOne(getStatement("getByCondition"), map);
    }

    @Override
    public List<BookGroupAppDTO> getBookGroupAppDTOSByBookGroupId(Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        return super.getSqlSession().selectList(getStatement("getBookGroupAppDTOSByBookGroupId"), map);
    }

    @Override
    public List<BookGroupIdAndCountDTO> getServerCountByBookGroupIds(List<Long> bookGroupIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupIds", bookGroupIds);
        return super.getSqlSession().selectList(getStatement("getServerCountByBookGroupIds"), map);
    }

    @Override
    public List<Long> getAllBookGroupId() {
        return super.getSqlSession().selectList(getStatement("getAllBookGroupId"));
    }
}
