package com.pcloud.book.group.entity;

import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import lombok.Data;

/**
 * 企业微信落地页(ResourcePageWxwork)实体类
 *
 * @author 
 * @since 2021-12-02 14:30:15
 */
@Data
public class ResourcePageWxwork extends BaseEntity {
    private static final long serialVersionUID = -95982243193843516L;
    /**
     * 主键
     */
    private Long id;
    /**
     * 资源页id
     */
    private Long resourcePageId;
    /**
     * 模板类型1自定义2固定3模板其他
     */
    private Integer templateType;
    /**
     * 是否展示图书信息1是0否
     */
    private Integer displayBook;
    /**
     * 引导语
     */
    private String guide;
    /**
     * 二维码类型（1企微个人码2企微群码3crm个人码4crm群码）
     */
    private Integer qrcodeType;
    /**
     * 二维码id
     */
    private Long qrcodeId;
    /**
     * 二维码url
     */
    private String qrcodeUrl;
    /**
     * 自定义背景图
     */
    private String basePic;
    /**
     * 自定义：二维码位置上方间距百分比
     */
    private Integer topSpace;
    /**
     * 自定义：二维码位置左边间距百分比
     */
    private Integer leftSpace;
    /**
     * html生成图
     */
    private String htmlPic;
    /**
     * 其他模板参数
     */
    private String fixedSet;
    /**
     * 创建人
     */
    private Long createUser;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;



}

