package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;

/**
 * @描述：好友用户信息
 * @作者：zhuyajie
 * @创建时间：11:51 2019/9/20
 * @版本：1.0
 */
public class FriendsVO extends BaseDto {

    /**
     * 机器人id
     */
    private String robotId;

    /**
     * 微信用户ID
     */
    private String wxUserId;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 头像
     */
    private String headPic;

    /**
     * 性别
     */
    private Integer sex;

    /**
     * 国家
     */
    private String country;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 添加时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    /**
     * 状态
     */
    private String state;

    /**
     * 累积发言次数
     */
    private Integer speakCount;

    /**
     * 7天累积发言次数
     */
    private Integer speakCountLast7;

    /**
     * 最后一次发言时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date  lastSpeakTime;

    public String getRobotId() {
        return robotId;
    }

    public void setRobotId(String robotId) {
        this.robotId = robotId;
    }

    public String getWxUserId() {
        return wxUserId;
    }

    public void setWxUserId(String wxUserId) {
        this.wxUserId = wxUserId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHeadPic() {
        return headPic;
    }

    public void setHeadPic(String headPic) {
        this.headPic = headPic;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Integer getSpeakCount() {
        return speakCount;
    }

    public void setSpeakCount(Integer speakCount) {
        this.speakCount = speakCount;
    }

    public Integer getSpeakCountLast7() {
        return speakCountLast7;
    }

    public void setSpeakCountLast7(Integer speakCountLast7) {
        this.speakCountLast7 = speakCountLast7;
    }

    public Date getLastSpeakTime() {
        return lastSpeakTime;
    }

    public void setLastSpeakTime(Date lastSpeakTime) {
        this.lastSpeakTime = lastSpeakTime;
    }

    @Override
    public String toString() {
        return "FriendsVO{" +
                "robotId='" + robotId + '\'' +
                ", wxUserId='" + wxUserId + '\'' +
                ", nickName='" + nickName + '\'' +
                ", headPic='" + headPic + '\'' +
                ", sex=" + sex +
                ", country='" + country + '\'' +
                ", province='" + province + '\'' +
                ", city='" + city + '\'' +
                ", createTime=" + createTime +
                ", state='" + state + '\'' +
                ", speakCount=" + speakCount +
                ", speakCountLast7=" + speakCountLast7 +
                ", lastSpeakTime=" + lastSpeakTime +
                '}';
    }
}
