package com.pcloud.book.timecontrol.mapper;

import com.pcloud.book.timecontrol.dto.*;
import com.pcloud.book.timecontrol.entity.TimeControlTaskSend;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @date: 2020年01月31日 20:05
 * @Author: Zcy
 * @Descprition
 */
@Component
public interface TimeControlTaskSendMapper {

    void batchInsert(List<TimeControlTaskSend> taskSendList);

    List<TaskSendDto> listTodayTask();

    void cancelSend(@Param("subscribeId") Integer subscribeId, @Param("sendState") Integer sendState);

    void cancelSendByTaskId(Integer taskId);

    void cancelSendByItemId(Integer taskItemId);

    /**
     * 查询已发送消息数
     */
    Integer countMsgSend(@Param("taskId") Integer taskId, @Param("bookId") Integer bookId);

    /**
     * 查询今日未发送消息数
     */
    Integer countTodayNotSend(@Param("taskId") Integer taskId, @Param("bookId") Integer bookId, @Param("sendDay") String sendDay);

    void updateSendState(@Param("sendId") Integer sendId, @Param("sendState") Integer sendState, @Param("completeState") Integer completeState);

    TimeControlTaskSend getById(Integer taskSendId);

    Integer getNoCompletedItem(Integer taskId);

    Integer todayTaskSendCount();

    Integer todayTaskNotSendCount(@Param("agentId") Long agentId);

    List<String> getTaskSendDateList(@Param("date") String date);

    Integer getTaskItemSendCount(@Param("startTime") String startTime,@Param("endTime") String endTime,@Param("robotWxId") String robotWxId,@Param("taskName") String taskName,@Param("sendContent") String sendContent);

    List<TaskItemSendDto> listTaskItemSendRecord4Pcloud(@Param("pageNum") Integer pageNum, @Param("numPerPage") Integer numPerPage, @Param("startTime") String startTime, @Param("endTime") String endTime, @Param("robotWxId") String robotWxId, @Param("taskName") String taskName, @Param("sendContent") String sendContent);

    Integer getTaskItemSendUserCount(@Param("wxIds") List<String> wxIds,@Param("taskItemId") Integer taskItemId, @Param("robotWxId") String robotWxId,
                                     @Param("startTime") String startTime, @Param("endTime") String endTime);

    List<TaskSendUserDto> listTaskItemSendUser4Pcloud(@Param("pageNum") Integer pageNum, @Param("numPerPage") Integer numPerPage,@Param("wxIds") List<String> wxIds, @Param("taskItemId") Integer taskItemId, @Param("robotWxId") String robotWxId,
                                                      @Param("startTime") String startTime, @Param("endTime") String endTime);

    List<SubscribeTaskUserDTO> getTaskNoCompletedCount(@Param("wxIds") List<String> wxIds, @Param("taskId") Integer taskId);

    Integer getNoCompletedCount(@Param("subscribeId") Integer subscribeId);

    Integer getCompletedCount(Integer subscribeId);

    List<TaskProgressItemDTO> getUserTaskItemProgress(@Param("taskId")Integer taskId, @Param("wxUserId") String wxUserId);

  void updateSendState4Week();

    List<TaskSendDto> listTodayTask4Week(@Param("taskItemId")Integer taskItemId, @Param("weekDay")Integer weekDay);

    void addSendCount(Integer id);
}
