package com.pcloud.book.advertising.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

/**
 * 群标记广告主
 */
public class AdvertisingGroupTag extends BaseEntity{

    /**
     * 被标记的图书id
     */
    private Long tagBookId;

    /**
     * 群二维码id
     */
    private Long groupQrcodeId;

    /**
     * 品牌方id
     */
    private Long brandId;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    public Long getTagBookId() {
        return tagBookId;
    }

    public void setTagBookId(Long tagBookId) {
        this.tagBookId = tagBookId;
    }

    public Long getGroupQrcodeId() {
        return groupQrcodeId;
    }

    public void setGroupQrcodeId(Long groupQrcodeId) {
        this.groupQrcodeId = groupQrcodeId;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        return "AdvertisingGroupTag{" +
                "tagBookId=" + tagBookId +
                ", groupQrcodeId=" + groupQrcodeId +
                ", brandId=" + brandId +
                ", createTime=" + createTime +
                '}';
    }
}