package com.pcloud.book.consumer.live;

import com.google.common.collect.Lists;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.liveapp.live.dto.CourseListDto;
import com.pcloud.liveapp.live.service.LiveCourseService;

import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class LiveCons {

    @Resource
    private LiveCourseService liveCourseService;

    @ParamLog("[获取直播课表]")
    public List<CourseListDto> getList4BroadcastReminder(Long serverId, String serverType) {
        try {
            ResponseEntity<ResponseDto<List<CourseListDto>>> reminder = liveCourseService.getList4BroadcastReminder(serverId, serverType);
            log.info("[获取直播课表] appId:{}, serverType:{}, reminder:{}", serverId, serverType, reminder);
            List<CourseListDto> courseListDtos = ResponseHandleUtil.parseList(reminder, CourseListDto.class);
            return courseListDtos;
        } catch (PermissionException e) {
            log.error("[获取直播课表] error appId:{}, serverType:{}, e:{}", serverId, serverType, e);
        }
        return Lists.newArrayList();
    }

}
