package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.BookGroupCipherUserDao;
import com.pcloud.book.group.dto.DayCountDTO;
import com.pcloud.book.group.entity.BookGroupCipherUser;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/9/24 15:19
 **/
@Component("bookGroupCipherUserDao")
public class BookGroupCipherUserDaoImpl extends BaseDaoImpl<BookGroupCipherUser> implements BookGroupCipherUserDao {
    @Override
    public Long getBookGroupIdByWxUserId(String wxUserId) {
        return this.getSqlSession().selectOne(this.getStatement("getBookGroupIdByWxUserId"), wxUserId);
    }

    @Override
    public Integer getFriendsCountByBookGroup(Long bookGroupId) {
        return getSessionTemplate().selectOne(getStatement("getFriendsCountByBookGroup"), bookGroupId);
    }


    @Override
    public List<DayCountDTO> getBookGroupFriendsCountByDay(Long bookGroupId, String startTime, String endTime) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return getSessionTemplate().selectList(getStatement("getBookGroupFriendsCountByDay"), map);
    }
}
