package com.pcloud.book.group.service.impl;

import com.pcloud.book.group.biz.BookGroupBiz;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.GroupCipherDTO;
import com.pcloud.book.group.dto.GroupUseDTO;
import com.pcloud.book.group.dto.PersonalQrcodeDTO;

import com.pcloud.book.group.dto.QueryByBookAdviserDTO;
import com.pcloud.book.group.dto.ResourceBrowseParamDto;
import com.pcloud.book.group.service.BookGroupService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.dto.StoreFlowInfoDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiOperation;

/**
 * Description 社群书内部接口实现类
 * Created by PENG on 2019/5/14.
 */
@RestController("bookGroupService")
@RequestMapping("bookGroupService")
public class BookGroupServiceImpl implements BookGroupService {

    @Autowired
    private BookGroupBiz bookGroupBiz;

    /**
     * 获取社群书基本信息
     */
    @Override
    @RequestMapping(value = "getBookGroupInfo", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BookGroupDTO>> getBookGroupInfo(@RequestParam("bookGroupId") Long bookGroupId) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getBookGroupInfo(bookGroupId));
    }

    /**
     * 批量获取社群书基本信息
     */
    @Override
    @RequestMapping(value = "getBookGroupInfoByIds", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<Map<Long, BookGroupDTO>>> getBookGroupInfoByIds(@RequestBody List<Long> bookGroupIds) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getBookGroupInfoByIds(bookGroupIds));
    }

    /**
     * 根据bookId和AdviserId批量获取社群书基本信息
     */
    @Override
    @PostMapping(value = "getBookGroupInfoByBookIdAndAdviserId")
    public ResponseEntity<ResponseDto<List<BookGroupDTO>>> getBookGroupInfoByBookIdAndAdviserId(@RequestBody QueryByBookAdviserDTO queryByBookAdviserDTO) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getBookGroupInfoByBookIdAndAdviserId(queryByBookAdviserDTO.getBookIds(),queryByBookAdviserDTO.getAdviserIds()));
    }

    /**
     * 为信息流批量获取社群书基本信息
     */
    @Override
    @RequestMapping(value = "getFlowInfoByBookGroupIds", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<Map<Long, StoreFlowInfoDto>>> getFlowInfoByBookGroupIds(@RequestBody List<Long> bookGroupIds) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getFlowInfoByBookGroupIds(bookGroupIds));
    }

    /**
     * 获取指定条数社群书基本信息
     */
    @Override
    @RequestMapping(value = "getBookGroupInfoByChannelId",method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<Map<Long, StoreFlowInfoDto>>> getBookGroupInfoByChannelId(@RequestParam("channelId")Long channelId, @RequestParam("itemNum")Integer itemNum) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getBookGroupInfoByChannelId(channelId, itemNum));
    }

    /**
     * 知识商城获取社群书信息
     */
    @Override
    @RequestMapping(value = "listBookGroup4KnowledgeMall",method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<PageBeanNew<StoreFlowInfoDto>>> listBookGroup4KnowledgeMall(@RequestParam(value="channelId",required = false)Long channelId,
                                                                                                  @RequestParam("currentPage")int currentPage,
                                                                                                  @RequestParam("numPerPage") int numPerPage) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.listBookGroup4KnowledgeMall(channelId, currentPage, numPerPage));
    }

    /**
     * 获取社群书基本信息
     */
    @Override
    @RequestMapping(value = "getBaseInfoBySceneId", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BookGroupDTO>> getBaseInfoBySceneId(@RequestParam("sceneId") Long sceneId) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getBaseInfoBySceneId(sceneId));
    }



    @Override
    @RequestMapping(value = "updatePersonQrcode",method = RequestMethod.POST)
    public void updatePersonQrcode(@RequestBody PersonalQrcodeDTO personalQrcodeDTO) throws BizException {
        bookGroupBiz.updatePersonQrcode(personalQrcodeDTO);
    }

    /**
     * 获取暗号状态
     */
    @ApiOperation("获取暗号状态")
    @GetMapping("/getCipherState")
    @Override
    public ResponseEntity<ResponseDto<Integer>> getCipherState(String cipher) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getCipherState(cipher));
    }

    /**
     * 更新密码状态为已使用
     */
    @ApiOperation("更新暗号状态为已使用")
    @GetMapping("/updateCipherStateToUsed")
    @Override
    public void updateCipherStateToUsed(String cipher, String wxId) throws BizException {
        bookGroupBiz.updateCipherStateToUsed(cipher,wxId);
    }

    /**
     * 获取个人二维码方式群已使用和未使用数量
     */
    @ApiOperation("获取个人二维码方式群已使用和未使用数量")
    @PostMapping("/getGroupUse")
    @Override
    public ResponseEntity<ResponseDto<GroupUseDTO>> getGroupUse(@RequestBody List<String> altIds) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getGroupUse(altIds));
    }

    @ApiOperation("获取暗号基本信息")
    @GetMapping("/getJoinGroupCipher")
    @Override
    public ResponseEntity<ResponseDto<GroupCipherDTO>> getJoinGroupCipher(@RequestParam("cipher")String cipher) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getJoinGroupCipher(cipher));
    }

    /**
    * @description 获取资源浏览数据
    * @author 戴兴
    * @date 2019/8/8 20:45
    */
    @Override
    @PostMapping("getResourcesBrowseCount")
    public ResponseEntity<ResponseDto<Map<Long, Long>>> getResourcesBrowseCount(@RequestBody ResourceBrowseParamDto resourceBrowseParamDto) {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getResourcesBrowseCount(resourceBrowseParamDto));
    }

    @GetMapping("getBookGroupFriendsCountByDay")
    public ResponseEntity<ResponseDto<Map<String, Integer>>> getBookGroupFriendsCountByDay(
            @RequestParam("bookGroupId") Long bookGroupId, @RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate) {
        Map<String, Integer> map = bookGroupBiz.getBookGroupFriendsCountByDay(bookGroupId, startDate, endDate);
        return ResponseHandleUtil.toResponse(map);
    }

    @ApiOperation("将1v1旧数据的关键词全部都干掉，有应用或作品的挂在社群书配置资源里面")
    @GetMapping("dealSelfBookGroupKeywordToServer")
    @Override
    public void dealSelfBookGroupKeywordToServer() {
        bookGroupBiz.dealSelfBookGroupKeywordToServer();
    }

    @ApiOperation("补充1v1旧数据的暗号")
    @GetMapping("fillSelfBookGroupCipher")
    @Override
    public void fillSelfBookGroupCipher() {
        bookGroupBiz.fillSelfBookGroupCipher();
    }

}
