package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletAppOrProductDTO;
import com.pcloud.book.applet.dto.AppletRecordDTO;
import com.pcloud.book.applet.entity.AppletRecord;
import com.pcloud.common.page.PageBeanNew;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * (AppletRecord)表服务接口
 *
 * @author makejava
 * @since 2020-08-27 15:49:57
 */
public interface AppletRecordBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletRecord getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param appletRecord 实例对象
     * @return 主键
     */
    Long insert(AppletRecord appletRecord);

    /**
     * 修改数据
     *
     * @param appletRecord 实例对象
     */
    void update(AppletRecord appletRecord);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 获取足迹列表
     * @param wechatUserId
     * @param date
     * @param recordTypes
     * @param queryName
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletRecordDTO> listAppletRecord(Long wechatUserId, String date, List<Integer> recordTypes, String queryName, Integer currentPage, Integer numPerPage);

    List<String> listUnreachableDate(Long wechatUserId);

    /**
     * 从足迹获取应用或作品浏览人数
     * @param recordType
     * @param serveIds
     * @return
     */
    Map<Long, AppletAppOrProductDTO> getAppOrProductBrowseCount(Integer recordType, List<Long> serveIds);

    void fillAppletRecord(List<AppletRecordDTO> recordList, Integer bookType);

    Object handleAppletRecordTypeCode(Long lastAppletRecordId);

    void stopHandleAppletRecordTypeCode();
}
