package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.entity.AppletNewsServe;
import com.pcloud.book.applet.biz.AppletNewsServeBiz;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import io.swagger.annotations.ApiOperation;

import java.util.Map;

/**
 * (AppletNewsServe)表控制层
 *
 * @author makejava
 * @since 2020-06-30 16:56:08
 */
@RestController("appletNewsServeFacade")
@RequestMapping("appletNewsServe")
public class AppletNewsServeFacade {
    
    @Autowired
    private AppletNewsServeBiz appletNewsServeBiz;

    
    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(appletNewsServeBiz.getById(id));
    }
    
    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token, 
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage, 
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage) 
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(appletNewsServeBiz.getList(currentPage, numPerPage));
    }
    
    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@RequestHeader("token") String token, @RequestBody AppletNewsServe appletNewsServe)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(appletNewsServeBiz.insert(appletNewsServe));
    }
    
    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@RequestHeader("token") String token,@RequestBody AppletNewsServe appletNewsServe) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        appletNewsServeBiz.update(appletNewsServe);
        return new ResponseDto<>();
    }
    
    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        appletNewsServeBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @GetMapping("exportClickCountExcel")
    public ResponseDto<Map<String, Object>> exportClickCountExcel(@RequestParam(value = "count", required = false, defaultValue = "50") Integer count,
                                                                  @RequestParam("startDate") String startDate,
                                                                  @RequestParam("endDate") String endDate,
                                                                  @RequestParam("sourceType") Integer sourceType) {
        Map<String, Object> map = appletNewsServeBiz.exportClickCountExcel(count, startDate, endDate, sourceType);
        return new ResponseDto<>(map);
    }

}