package com.pcloud.book.book.biz;

import com.pcloud.book.book.vo.request.BookQrcodeWxworkRequestVO;
import com.pcloud.book.book.vo.response.BookQrcodeWxworkResponseVO;

import java.util.List;

/**
 * 二维码配置企业微信
 * @author：zhuyajie
 * @date：2020/12/22 18:24
 *  * @param null
 */
public interface BookQrcodeWxworkBiz {


    /**
     * 二维码设置关联企业微信码
     * @author：zhuyajie
     * @date：2020/12/23 10:40
     *  * @param null
     */
    void setWxworkQrcode(BookQrcodeWxworkRequestVO bookQrcodeWxworkRequestVO);

    /**
     * 查配置的企业微信码id
     * @author：zhuyajie
     * @date：2020/12/23 11:09
     *  * @param null
     */
    Long getWxworkQrcodeIdBySceneOrBookGroup(Long sceneId, Long bookGroupId, Integer wxworkQrcodeType);

    /**
     * 查配置的企业微信码及信息
     * @author：zhuyajie
     * @date：2020/12/23 11:21
     *  * @param null
     */
    BookQrcodeWxworkResponseVO getWxworkQrcodeInfoBySceneOrBookGroup(Long sceneId, Long bookGroupId, Integer wxworkQrcodeType);

    /**
     * 根据书刊查RAYS码配置的企业微信
     * @author：zhuyajie
     * @date：2020/12/23 16:41
     *  * @param null
     */
    List<BookQrcodeWxworkResponseVO> getWxworkQrcodeInfoByBook4Rays(Long bookId, Long channelId, Long adviserId);
}
