package com.pcloud.book.book.facade;

import com.pcloud.book.book.biz.BookQrcodeWxworkBiz;
import com.pcloud.book.book.vo.request.BookQrcodeWxworkRequestVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.SessionUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.ApiOperation;

/**
 * @ClassName com.pcloud.book.book.facade.BookQrcodeWxworkFacade
 * @Author zhuyajie
 * @Description 企业微信码配置
 * @Date 2020/12/23 11:30
 * @Version 1.0
 **/
@RestController("bookWxworkFacade")
@RequestMapping("bookWxwork")
public class BookWxworkFacade {

    @Autowired
    private BookQrcodeWxworkBiz bookQrcodeWxworkBiz;

    @ApiOperation("二维码设置关联企业微信码")
    @PostMapping("setWxworkQrcode")
    public ResponseDto<?> setWxworkQrcode(@RequestHeader("token") String token, @RequestBody BookQrcodeWxworkRequestVO bookQrcodeWxworkRequestVO) {
        SessionUtil.getToken4Redis(token);
        bookQrcodeWxworkBiz.setWxworkQrcode(bookQrcodeWxworkRequestVO);
        return new ResponseDto<>();
    }

    @ApiOperation("查配置的企业微信码及信息")
    @GetMapping("getWxworkQrcodeInfoBySceneOrBookGroup")
    public ResponseDto<?> getWxworkQrcodeInfoBySceneOrBookGroup(
            @RequestHeader("token") String token,
            @RequestParam(value = "sceneId", required = false) Long sceneId,
            @RequestParam(value = "bookGroupId", required = false) Long bookGroupId,
            @RequestParam("wxworkQrcodeType") Integer wxworkQrcodeType) {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(bookQrcodeWxworkBiz.getWxworkQrcodeInfoBySceneOrBookGroup(sceneId, bookGroupId, wxworkQrcodeType));
    }

    @ApiOperation("根据书刊查RAYS码配置的企业微信")
    @GetMapping("getWxworkQrcodeInfoByBook4Rays")
    public ResponseDto<?> getWxworkQrcodeInfoByBook4Rays(
            @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId, @RequestParam("adviserId") Long adviserId) {
        return new ResponseDto<>(bookQrcodeWxworkBiz.getWxworkQrcodeInfoByBook4Rays(bookId, channelId, adviserId));
    }
}
