/**
 * 
 */
package com.pcloud.book.book.service.impl;

import com.pcloud.book.book.biz.BookBiz;
import com.pcloud.book.book.biz.BookLabelBiz;
import com.pcloud.book.book.biz.BookQrcodeWxworkBiz;
import com.pcloud.book.book.dto.BookAdviserUpdateTimeDTO;
import com.pcloud.book.book.dto.BookDetialDTO;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookInfo4AnlysicsDTO;
import com.pcloud.book.book.dto.BookInfoAnalysicsDTO;
import com.pcloud.book.book.dto.BookInfoAndAuthStatusDTO;
import com.pcloud.book.book.enums.WxworkQrcodeType;
import com.pcloud.book.book.service.BookService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2016年12月23日,下午5:28:29 @版本：1.0
 */
@RestController("bookService")
@RequestMapping("bookService")
public class BookServiceImpl implements BookService {

	@Autowired
	private BookBiz bookBiz;
	@Autowired
	private BookLabelBiz bookLabelBiz;
	@Autowired
	private BookQrcodeWxworkBiz bookQrcodeWxworkBiz;

	/**
	 * 获取书籍信息
	 */
	@Override
	@RequestMapping(value = "/getBaseById", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<BookDto>> getBaseById(
			@RequestParam(value = "bookId", required = false) Long bookId) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getBaseById(bookId));
	}

	/**
	 * 批量获取书籍信息
	 */
	@Override
	@RequestMapping(value = "/getListByIds", method = RequestMethod.POST)
	public ResponseEntity<ResponseDto<Map<Long, BookDto>>> getListByIds(
			@RequestBody(required = false) List<Long> bookIds) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getListByIds(bookIds));
	}

	/**
	 * 批量获取书籍信息（书名 与书刊序号 封面图）
	 * 
	 * @param bookIds
	 * @return
	 * @throws BizException
	 */
	@Override
	@RequestMapping(value = "/listBaseByIds", method = RequestMethod.POST)
	public ResponseEntity<ResponseDto<Map<Long, BookDto>>> listBaseByIds(
			@RequestBody(required = false) List<Long> bookIds) {
		return ResponseHandleUtil.toResponse(bookBiz.listBaseByIds(bookIds));
	}


	@Override
	@RequestMapping(value = "/listDetailByIds", method = RequestMethod.POST)
	public ResponseEntity<ResponseDto<Map<String, BookDto>>> listDetailByIds(@RequestBody(required = false)BookDetialDTO bookDetialDTO) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.listDetailByIds(bookDetialDTO));
	}

	/**
	 * 根据名称获取ID
	 */
	@Override
	@RequestMapping(value = "/getIdsByName", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<List<Long>>> getIdsByName(
			@RequestParam(value = "bookName", required = false) String bookName) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getIdsByName(bookName));
	}
	
	/**
	 * 根据名称获取ID
	 */
	@Override
	@RequestMapping(value = "/getIdsByName2", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<List<Long>>> getIdsByName(
			@RequestParam(value = "bookName", required = true) String bookName,
			@RequestParam(value = "adviserId", required = true) Long adviserId) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getIdsByName(bookName, adviserId));
	}

	/**
	 * 根据ISBN获取书籍信息
	 */
	@Override
	@RequestMapping(value = "/getByIsbn", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<BookDto>> getByIsbn(@RequestParam(value = "isbn", required = false) String isbn,
			@RequestParam(value = "serialNumber", required = false) String serialNumber) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getByIsbn(isbn, serialNumber));
	}

	/**
	 * 根据ISBN码获取书籍详情（包含二维码个数，应用个数，商品个数）
	 */
	@Override
	@RequestMapping(value = "/getDetailByIsbn", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<BookDto>> getDetailByIsbn(
			@RequestParam(value = "isbn", required = false) String isbn,
			@RequestParam(value = "serialNumber", required = false) String serialNumber) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getDetailByIsbn(isbn, serialNumber));
	}

	@Override
	@RequestMapping(value = "/listBookByAppId", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<List<BookDto>>> listBookByAppId(
			@RequestParam(value = "appId", required = false) Long appId,
			@RequestParam(value = "channelId", required = false) Long channelId) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.listBookByAppId(appId, channelId));
	}

	@Override
	@RequestMapping(value = "/listByIsbn", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Map<Long, BookDto>>> listByIsbn(
			@RequestParam(value = "isbn", required = false) String isbn) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.listByIsbn(isbn));
	}

	@Override
	@RequestMapping(value = "/getBookById", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<BookDto>> getBookById(@RequestParam(value = "adviserId") Long adviserId,
			@RequestParam(value = "channelId") Long channelId, @RequestParam(value = "bookId") Long bookId)
					throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getBookById(adviserId, channelId, bookId));
	}

	@Override
	@RequestMapping(value = "/getBookTempletIdId", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Long>> getBookTempletIdId(
			@RequestParam(value = "adviserId") Long adviserId,
			@RequestParam(value = "channelId") Long channelId,
			@RequestParam(value = "bookId") Long bookId) throws BizException{
		return ResponseHandleUtil.toResponse(bookBiz.getBookTempletIdId(adviserId, channelId, bookId));
	}

	@Override
	@RequestMapping(value = "/updateTimeById", method = RequestMethod.GET)
	public void updateTimeById(@RequestParam(value = "bookId")Long bookId) throws BizException {

		bookBiz.updateTimeById(bookId);
	}

	@Override
	@RequestMapping(value = "/updateTimeByIds", method = RequestMethod.POST)
	public void updateTimeByIds(@RequestBody BookAdviserUpdateTimeDTO bookAdviserUpdateTimeDTO) throws BizException {
		bookBiz.updateTimeByIds(bookAdviserUpdateTimeDTO);
	}

	@Override
	@RequestMapping(value = "/getBookInfoBy", method = RequestMethod.POST)
	public ResponseEntity<ResponseDto<Map<String, BookInfoAnalysicsDTO>>> getBookInfoBy(@RequestBody List<BookInfoAnalysicsDTO>
																									bookInfoAnalysicsDTOS,@RequestParam(value = "monthDate",required = false) String monthDate) throws BizException {

		return ResponseHandleUtil.toResponse(bookBiz.getBookInfoBy(bookInfoAnalysicsDTOS,monthDate));
	}

	@PostMapping("getBookAnalysis")
	@Override
	public ResponseEntity<ResponseDto<Map<Long, BookInfo4AnlysicsDTO>>> getBookAnalysis(@RequestBody List<Long> bookIds,@RequestParam(value = "monthDate",required = false)  String
			monthDate) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getBookAnalysis(bookIds,monthDate));
	}

	@Override
	@GetMapping("getBaseAndAuthStatus")
	public ResponseEntity<ResponseDto<BookInfoAndAuthStatusDTO>> getBaseAndAuthStatus
			(@RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId,
			 @RequestParam("adviserId") Long adviserId) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getBaseAndAuthStatus(bookId, channelId, adviserId));
	}

	@ApiOperation("根据书名或isbn编号查询书")
	@RequestMapping(value = "/getIdsByNameOrISBN", method = RequestMethod.GET)
	@Override
	public ResponseEntity<ResponseDto<List<Long>>> getIdsByNameOrISBN(
			@RequestParam(value = "keyword") String keyword,
			@RequestParam(value = "adviserId") Long adviserId
	) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getIdsByNameOrISBN(keyword, adviserId));
	}

	@ApiOperation("根据书名模糊匹配，获得所有book_id")
	@RequestMapping(value = "/getBookIdsByBookName", method = RequestMethod.GET)
	@Override
	public ResponseEntity<ResponseDto<List<Long>>> getBookIdsByBookName(
			@RequestParam(value = "bookName") String bookName
	) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getBookIdsByBookName(bookName));
	}

	@ApiOperation("根据isbn模糊匹配，获得所有book_id")
	@RequestMapping(value = "/getBookIdsByIsbn", method = RequestMethod.GET)
	@Override
	public ResponseEntity<ResponseDto<List<Long>>> getBookIdsByIsbn(
			@RequestParam(value = "isbn") String isbn) throws BizException {
		return ResponseHandleUtil.toResponse(bookBiz.getBookIdsByIsbn(isbn));
	}

	@Override
	@RequestMapping(value = "/getLabelMapByIds", method = RequestMethod.POST)
	public ResponseEntity<ResponseDto<Map<Long, String>>> getLabelMapByIds(@RequestBody List<Long> labelIds) throws BizException {
		return ResponseHandleUtil.toResponse(bookLabelBiz.getLabelMapByIds(labelIds));
	}

	@Override
	@RequestMapping(value = "/checkIsLibraryBook", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Boolean>> checkIsLibraryBook(@RequestParam(value = "adviserId", required = false) Long adviserId,
																   @RequestParam(value = "bookId", required = false) Long bookId) {
		return ResponseHandleUtil.toResponse(bookBiz.checkIsLibraryBook(adviserId,bookId));
	}

	@Override
	@RequestMapping(value = "/clearCache4BookBaseInfo",method = RequestMethod.GET)
	public void clearCache4BookBaseInfo(@RequestParam("pwd") String pwd) {
		bookBiz.clearCache4BookBaseInfo(pwd);
	}

	@Override
	@GetMapping("getWxworkQrcodeIdBySceneOrBookGroup")
	public ResponseEntity<ResponseDto<Long>> getWxworkQrcodeIdBySceneOrBookGroup(@RequestParam(value = "sceneId", required = false) Long sceneId,
																		  @RequestParam(value = "bookGroupId", required = false) Long bookGroupId) {
		return ResponseHandleUtil.toResponse(bookQrcodeWxworkBiz.getWxworkQrcodeIdBySceneOrBookGroup(sceneId, bookGroupId, WxworkQrcodeType.SOP_QRCODE.getCode()));
	}

	@Override
	@GetMapping("getWxworkGroupQrcodeIdBySceneOrBookGroup")
	public ResponseEntity<ResponseDto<Long>> getWxworkGroupQrcodeIdBySceneOrBookGroup(@RequestParam(value = "sceneId", required = false) Long sceneId,
																				 @RequestParam(value = "bookGroupId", required = false) Long bookGroupId) {
		return ResponseHandleUtil.toResponse(bookQrcodeWxworkBiz.getWxworkQrcodeIdBySceneOrBookGroup(sceneId, bookGroupId, WxworkQrcodeType.GROUP_QRCODE.getCode()));
	}


}
