package com.pcloud.book.group.dto;

import com.pcloud.book.group.entity.BookGroup;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName com.pcloud.book.group.dto.BookGroupCreateDTO
 * @Author zhuyajie
 * @Description 社群码创建
 * @Date 2020/12/14 10:10
 * @Version 1.0
 **/
@Data
public class BookGroupCreateDTO extends BookGroup {

    @NotNull
    @ApiModelProperty("书刊id")
    private Long bookId;
    @NotNull
    @ApiModelProperty("渠道id")
    private Long channelId;
    @ApiModelProperty("编辑id")
    private Long adviserId;
    @NotNull
    @ApiModelProperty("社群码类型（普通群、1v1、小睿码）")
    private Integer joinGroupType;
    @ApiModelProperty("小睿码跳转类型")
    private Integer jumpType;
    @ApiModelProperty("小睿码自定义跳转链接")
    private String jumpUrl;
}
