package com.pcloud.book.keywords.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/28 14:38
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
public class KeywordStatisticsDTO implements Serializable {

    private static final long serialVersionUID = -1982118870769572480L;

    @ApiModelProperty("关键词id")
    private Long keywordId;

    @ApiModelProperty("关键词")
    private String keyword;

    @ApiModelProperty("累计触发次数")
    private Integer touchCount;

    @ApiModelProperty("最近7天触发次数")
    private Integer weekTouchCount;

    @ApiModelProperty("日平均触发次数")
    private Double avgDayTouchCount;

    @ApiModelProperty("最近触发时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastTouchTime;

    @ApiModelProperty("关键词创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date keywordCreateDate;

    public Long getKeywordId() {
        return keywordId;
    }

    public void setKeywordId(Long keywordId) {
        this.keywordId = keywordId;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Integer getTouchCount() {
        return touchCount;
    }

    public void setTouchCount(Integer touchCount) {
        this.touchCount = touchCount;
    }

    public Integer getWeekTouchCount() {
        return weekTouchCount;
    }

    public void setWeekTouchCount(Integer weekTouchCount) {
        this.weekTouchCount = weekTouchCount;
    }

    public Double getAvgDayTouchCount() {
        return avgDayTouchCount;
    }

    public void setAvgDayTouchCount(Double avgDayTouchCount) {
        this.avgDayTouchCount = avgDayTouchCount;
    }

    public Date getLastTouchTime() {
        return lastTouchTime;
    }

    public void setLastTouchTime(Date lastTouchTime) {
        this.lastTouchTime = lastTouchTime;
    }

    public Date getKeywordCreateDate() {
        return keywordCreateDate;
    }

    public void setKeywordCreateDate(Date keywordCreateDate) {
        this.keywordCreateDate = keywordCreateDate;
    }

    @Override
    public String toString() {
        return "KeywordStatisticsDTO{" +
                "keywordId=" + keywordId +
                ", keyword='" + keyword + '\'' +
                ", touchCount=" + touchCount +
                ", weekTouchCount=" + weekTouchCount +
                ", avgDayTouchCount=" + avgDayTouchCount +
                ", lastTouchTime=" + lastTouchTime +
                ", keywordCreateDate=" + keywordCreateDate +
                '}';
    }
}
