package com.pcloud.book.rightsSetting.dao.impl;

import com.pcloud.book.rightsSetting.entity.RightsSettingItemDetail;
import com.pcloud.book.rightsSetting.dao.RightsSettingItemDetailDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * (RightsSettingItemDetail)表数据库访问层
 *
 * @author makejava
 * @since 2020-05-18 22:28:12
 */
@Repository("rightsSettingItemDetailDaoImpl")
public class RightsSettingItemDetailDaoImpl extends BaseDaoImpl<RightsSettingItemDetail> implements RightsSettingItemDetailDao {

    @Override
    public void deleteByItemIds(List<Long> list) {
        this.getSqlSession().delete(getStatement("deleteByItemIds"), list);
    }

    @Override
    public List<RightsSettingItemDetail> getByItemIds(List<Long> list) {
        return this.getSqlSession().selectList(getStatement("getByItemIds"), list);
    }

    @Override
    public List<Long> getAdviserGroupIds(List<Long> ids) {
        return this.getSqlSession().selectList(getStatement("getAdviserGroupIds"), ids);
    }

    @Override
    public List<Long> getActivityGroupIds(List<Long> ids) {
        return this.getSqlSession().selectList(getStatement("getActivityGroupIds"), ids);
    }

    @Override
    public void deleteInvalidNews(List<Long> newsIds) {
        getSqlSession().delete(getStatement("deleteInvalidNews"), newsIds);
    }

    @Override
    public List<RightsSettingItemDetail> getByNewsIds(List<Long> newsIds) {
        return getSqlSession().selectList(getStatement("getByNewsIds"), newsIds);
    }

    @Override
    public List<RightsSettingItemDetail> getByActivityIds(List<Long> activityIds) {
        return getSessionTemplate().selectList(getStatement("getByActivityIds"), activityIds);
    }

    @Override
    public void deleteInvalidActivityGroups(List<Long> activityIds) {
        getSessionTemplate().delete(getStatement("deleteInvalidActivityGroups"), activityIds);
    }
}