package com.pcloud.book.book.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class BookFundDetailDto implements Serializable {
    /**
     * 书刊ID
     */
    @ApiModelProperty(value = "书刊ID")
    private Long bookId;

    /**
     * 基金名字
     */
    @ApiModelProperty(value = "基金名字")
    private String fundName;

    /**
     * 转让方名字
     */
    @ApiModelProperty(value = "转让方名字")
    private String transferor;

    /**
     * 购买金额
     */
    @ApiModelProperty(value = "购买金额")
    private BigDecimal purchaseMoney;

    /**
     * 开始时间
     */
    @ApiModelProperty(value = "开始时间")
    private Date startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    /**
     * 书刊是否有编辑关联
     */
    private Boolean isHaveAdviser;

    /**
     * 书刊是否有基金支持
     */
    private Boolean isFundSupport;

    /**
     * 书刊是否有基金
     */
    private Boolean isHaveFund;

    /**
     * 冻结状态
     */
    private Integer FreezeStatus;


    @ApiModelProperty("冻结时间")
    private Date freezeTime;

    @ApiModelProperty("解冻时间")
    private Date thawTime;

    @ApiModelProperty("批次号")
    private String batchNumber;

}
