package com.pcloud.book.es.service;

import com.pcloud.book.es.dto.ESBookGroupQrcodeDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "pcloud-service-book", qualifiers = "esBookGroupQrcodeServiceCloud", path = "book/v1.0/esBookGroupQrcode")
@Api(description = "ES内部接口")
public interface ESBookGroupQrcodeService {

    @ApiOperation("通过微信群ID(xxx@chatroom)获取ES中的群信息")
    @RequestMapping(value = "searchByWxGroupIds", method = RequestMethod.GET)
    List<ESBookGroupQrcodeDTO> searchByWxGroupIds(@RequestParam("wxGroupIds") List<String> wxGroupIds);

    @ApiOperation("更新ES中的群信息")
    @RequestMapping(value = "save",method = RequestMethod.POST)
    void save(@RequestBody List<ESBookGroupQrcodeDTO> dtos);

}
