package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletNewsPoolDTO;
import com.pcloud.book.applet.entity.AppletNewsPool;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface AppletNewsPoolBiz {
    /**
     * 根据id获取咨询详情
     * @param id
     * @return
     */
    AppletNewsPool getById(Long id);

    /**
     * 根据id更新资讯
     * @param appletNewsPool
     */
    void update(AppletNewsPool appletNewsPool);

    /**
     * 批量删除
     * @param ids
     */
    void batchDelete(List<Long> ids);

    /**
     * 资讯池分页
     * @param currentPage
     * @param numPerPage
     * @param newsName
     * @param source
     * @return
     */
    PageBeanNew<AppletNewsPool> listNewsPage(Integer currentPage, Integer numPerPage, String newsName, String source);

    /**
     * 获取来源列表
     * @return
     */
    List<String> listSource();

    /**
     * 批量导入到资讯
     * @param appletNewsPoolDTO
     */
    void batchImport(AppletNewsPoolDTO appletNewsPoolDTO);
}
