package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.BuyBookRequestReplyBiz;
import com.pcloud.book.applet.dto.BuyBookRequestReplyDTO;
import com.pcloud.book.applet.entity.BuyBookRequestReply;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * (BuyBookRequestReply)表控制层
 *
 * @author dominic_z
 * @since 2020年12月25日 16:25:37
 */
@RestController("buyBookRequestReplyFacade")
@RequestMapping("buyBookRequestReply")
public class BuyBookRequestReplyFacade {

    @Autowired
    private BuyBookRequestReplyBiz buyBookRequestReplyBiz;

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@RequestHeader("token") String token,
                                 @RequestBody() BuyBookRequestReply buyBookRequestReply) {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(buyBookRequestReplyBiz.insert(buyBookRequestReply));
    }

    @ApiOperation("通过购书记录Id获取回复消息")
    @GetMapping("getByRequestId")
    public ResponseDto<List<BuyBookRequestReplyDTO>> getByRequestId(@RequestHeader("token") String token,
                                                                    @RequestParam("requestId") Long requestId) {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(buyBookRequestReplyBiz.getByRequestId(requestId));
    }

    @ApiOperation("删除回复记录")
    @GetMapping("deleteById")
   public ResponseDto<?> deleteById(@RequestHeader("token") String token,
                                @RequestParam("id") Long id){
        SessionUtil.getToken4Redis(token);
        buyBookRequestReplyBiz.deleteById(id);
        return new ResponseDto<>();
   }
}
