package com.pcloud.book.book.facade;

import com.pcloud.book.book.dto.BookFreezeDto;
import com.pcloud.book.book.entity.BookFreeze;
import com.pcloud.book.book.entity.ThawEarning;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.codehaus.jackson.JsonParseException;
import org.springframework.web.bind.annotation.*;

/**
 * 图书冻结接口
 *
 * @author lili
 * @date 2018/1/18 18:08
 */
@Api(description = "图书冻结外部服务")
public interface BookFreezeFacade {

	/**
	 * 冻结收益
	 * 
	 * @param token
	 * @param bookFreeze
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "冻结收益", httpMethod = "POST")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookFreeze", value = "图书冻结实体", dataType = "BookFreeze", paramType = "body") })
	@RequestMapping(value = "create", method = RequestMethod.POST)
	ResponseDto<?> create(@RequestHeader(value = "token",required = false) String token, @RequestBody BookFreeze bookFreeze)
			throws BizException, PermissionException, JsonParseException;

	/**
	 * 获取冻结信息
	 * 
	 * @param bookId
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "获取冻结信息", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "getBaseById", method = RequestMethod.GET)
	ResponseDto<BookFreezeDto> getBaseById(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId)
			throws BizException, PermissionException, JsonParseException;

	/**
	 * 解冻收益
	 * 
	 * @param token
	 * @param thawEarning
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "解冻收益", httpMethod = "POST")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "thawEarning", value = "图书解冻实体", dataType = "ThawEarning", paramType = "body") })
	@RequestMapping(value = "thaw", method = RequestMethod.POST)
	ResponseDto<?> thaw(@RequestHeader(value = "token",required = false) String token, @RequestBody ThawEarning thawEarning)
			throws BizException, PermissionException, JsonParseException;

	/**
	 * 获取冻结信息（微信端）
	 * 
	 * @param userInfo
	 * @param bookId
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "获取冻结信息（微信端）", httpMethod = "GET")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "getBaseById4Wechat", method = RequestMethod.GET)
	ResponseDto<BookFreezeDto> getBaseById4Wechat(@CookieValue("userInfo") String userInfo,
			@RequestParam(value = "bookId", required = false) Long bookId)
			throws BizException, PermissionException, JsonParseException;
}
