package com.pcloud.book.clock.facade;

import com.pcloud.book.clock.eneity.BookClockKeywordCheckParam;
import com.pcloud.book.clock.eneity.CancelSelectedParam;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @Author: hzk
 * @Date: 2019/5/28 14:46
 * @Version 1.0
 */
@Api(description = "微信群打卡关键词设置")
public interface BookClockKeywordFacade {

    @ApiOperation(value = "获取关键词已关联的微信群书及分类", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
                        @ApiImplicitParam(name = "bookClockKeywordCheckParam", value = "关键词重复查询", dataType = "BookClockKeywordCheckParam", paramType = "body"),
    })
    @RequestMapping(value = "getKeywordBookClockList", method = RequestMethod.POST)
    ResponseDto<?> getKeywordBookClockList(@RequestHeader("token") String token, @RequestBody BookClockKeywordCheckParam bookClockKeywordCheckParam)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取关键词已关联的微信群书及分类(分页)", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookClockKeywordCheckParam", value = "关键词重复查询", dataType = "BookClockKeywordCheckParam", paramType = "body"),
    })
    @RequestMapping(value = "getKeywordBookClockList4HasSelected", method = RequestMethod.POST)
    ResponseDto<?> getKeywordBookClockList4HasSelected(@RequestHeader("token") String token, @RequestBody BookClockKeywordCheckParam bookClockKeywordCheckParam)
            throws BizException, PermissionException;

    @ApiOperation(value = "取消关联", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "cancelSelectedParam", value = "关键词取消关联", dataType = "CancelSelectedParam", paramType = "body"),
    })
    @RequestMapping(value = "cancelSelected", method = RequestMethod.POST)
    ResponseDto<?> cancelSelected(@RequestHeader("token") String token, @RequestBody CancelSelectedParam cancelSelectedParam)
            throws BizException, PermissionException;


}
