package com.pcloud.book.consumer.combinedmarketing;

import com.pcloud.combinedmarketing.memberActivity.dto.ActivityBaseInfoDTO;
import com.pcloud.combinedmarketing.memberActivity.dto.ActivityBaseInfoWithPriceDTO;
import com.pcloud.combinedmarketing.memberActivity.dto.UserActivityQueryDTO;
import com.pcloud.combinedmarketing.memberActivity.service.ActivityService;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @ClassName com.pcloud.book.consumer.combinedmarketing.MemberActivityConsr
 * @Author zhuyajie
 * @Description 平台会员
 * @Date 2021/9/16 11:16
 * @Version 1.0
 **/
@Component
@Slf4j
public class MemberActivityConsr {

    @Autowired
    private ActivityService activityService;

    public Map<Long, ActivityBaseInfoDTO> mapMemberActivityBase(List<Long> activityIds) {
        if (ListUtils.isEmpty(activityIds)) {
            return new HashMap<>();
        }
        log.info("查平台会员活动信息,activityIds="+activityIds);
        try {
            return ResponseHandleUtil.parseMap(activityService.mapMemberActivityBase(activityIds), Long.class,ActivityBaseInfoDTO.class);
        } catch (Exception e) {
            log.error("查平台会员活动信息activityService.mapMemberActivityBase失败" +e.getMessage(), e);
        }
        return new HashMap<>();
    }

    public Map<Long, ActivityBaseInfoWithPriceDTO> mapMemberActivityBaseWithPrice(List<Long> activityIds) {
        if (ListUtils.isEmpty(activityIds)) {
            return new HashMap<>();
        }
        log.info("查平台会员活动信息,activityIds="+activityIds);
        try {
            return ResponseHandleUtil.parseMap(activityService.mapMemberActivityBaseWithPrice(activityIds), Long.class,ActivityBaseInfoWithPriceDTO.class);
        } catch (Exception e) {
            log.error("查平台会员活动信息activityService.mapMemberActivityBaseWithPrice" +e.getMessage(), e);
        }
        return new HashMap<>();
    }

    public List<Long> getProductIdsByMemberActivity(Long activityId) {
        if (null == activityId) {
            return new ArrayList<>();
        }
        log.info("查平台会员作品id信息,activityIds=" + activityId);
        try {
            return ResponseHandleUtil.parseList(activityService.getProductIdsByMemberActivity(activityId), Long.class);
        } catch (Exception e) {
            log.error("查平台会员活动信息activityService.getProductIdsByMemberActivity" + e.getMessage(), e);
        }
        return new ArrayList<>();
    }

    /**
     * @Description  查会员信息及购买信息
     * @Author zhuyajie
     * @Date 10:45 2022/9/20
     **/
    public Map<Long, ActivityBaseInfoWithPriceDTO> mapMemberActivityByUser(List<Long> activityIds,Long userId) {
        if (ListUtils.isEmpty(activityIds)) {
            return new HashMap<>();
        }
        UserActivityQueryDTO dto = new UserActivityQueryDTO();
        dto.setActivityIds(activityIds);
        dto.setUserId(userId);
        log.info("查平台会员活动信息,activityIds="+activityIds+"=userId="+userId);
        try {
            return ResponseHandleUtil.parseMap(activityService.mapMemberActivityByUser(dto), Long.class,ActivityBaseInfoWithPriceDTO.class);
        } catch (Exception e) {
            log.error("查平台会员活动信息activityService.mapMemberActivityByUser" +e.getMessage(), e);
        }
        return new HashMap<>();
    }
}
