package com.pcloud.book.copyright.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author lily
 * @date 2018/12/3 11:26
 */
@Data
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SetAuthOpenParam implements Serializable {

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("编码可使用次数")
    private Integer codeUseCount;

    @ApiModelProperty("生成码个数")
    private Integer codeCount;

    @ApiModelProperty("购买链接地址")
    private String buyUrl;

    @ApiModelProperty("图书状态")
    private Integer bookStatus;

    @ApiModelProperty("验证类型")
    private Integer checkType;

    @ApiModelProperty("服务")
    private List<ServeVO> serves;

    @ApiModelProperty("是否包含条形码  C1001121 添加二维码，故该字段2为二维码")
    private Integer isHaveBarCode;

    @ApiModelProperty("书刊类型：0-现代纸书 1-社群书")
    private Integer authBookType;

    @ApiModelProperty("授权后仍需付费")
    private Integer isAuthorizedPay;

    @ApiModelProperty("打开支付功能；0：关闭；1：开启；")
    private Integer openPay;

    @ApiModelProperty("授权码组成；1-15位字母+数字，2-10位纯数字")
    private Integer codeComposeType;

}
