package com.pcloud.book.group.biz;

import com.pcloud.book.group.dto.MultiChannelContentItemDTO;
import com.pcloud.book.group.entity.MultiChannelContentItem;
import com.pcloud.common.page.PageBeanNew;
import java.util.List;

/**
 * (MultiChannelContentItem)表服务接口
 *
 * @author wubo 
 * @since 2022-06-06 19:12:16
 */
public interface MultiChannelContentItemBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    MultiChannelContentItem getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param multiChannelContentItem 实例对象
     * @return 主键
     */
    Long insert(MultiChannelContentItem multiChannelContentItem);

    /**
     * 修改数据
     *
     * @param multiChannelContentItem 实例对象
     */
    void update(MultiChannelContentItem multiChannelContentItem);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 通过主键软删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void softDeleteById(Long id);

    /**
     * 批量新增
     * @param multiChannelContentItems
     */
    void insert(List<MultiChannelContentItem> multiChannelContentItems);

    /**
     * 批量获取多渠道内容
     * @param multiChannelContentIds
     * @return
     */
    List<MultiChannelContentItemDTO> getByMultiChannelContentId(List<Long> multiChannelContentIds);
}
