package com.pcloud.book.group.constant;

import com.pcloud.book.group.dto.AutoUpdateGroupNumDTO;
import com.pcloud.common.constant.CacheConstant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * book业务常量类
 */
public class BookBusinessConstants {

    /**
     * 生成无书号二维码路由
     **/
    public static final String NO_ISBN_QRCODE_URI = "/group/info?rayBookId=";
    /**
     * 需更新微信群信息
     */
    public static final Map<String, AutoUpdateGroupNumDTO> GROUP_NUM_DTO_MAP = new ConcurrentHashMap<>(128);

    /**
     * 小号上次心跳时间缓存
     */
    public static final String ACTIVE_ROBOT_CACHE_KEY_PREFIX = "activerobot:";

    /**
     * 发邮件间隔时长
     */
    public static final String EMAIL_SPAN_TIME = "emailSpanTime:";

    /**
     * 收款状态
     */
    public enum CollectionStatus {
        /**
         * 代收款
         */
        COLLECTION(1),
        /**
         * 收款中
         */
        RECEIVING(2),
        /**
         * 收款成功
         */
        COLLECTION_SUCCESSFUL(3);

        private Integer code;

        CollectionStatus(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return code;
        }
    }

    /**
     * 个人号-出版社统计
     */
    public static final String AGENT_STATISTIC = CacheConstant.BOOK+"BOOKGROUP:getAgentStatisticsInfo";
    public static final String AGENT_STATISTIC_COUNT = CacheConstant.BOOK+"BOOKGROUP:getAgentStatisticsInfo_count";
    /**
     * 平台端-社群书分析
     */
    public static final String BOOKGROUP_ANALYSIS = CacheConstant.BOOK+"BOOKGROUP:listPageBookGroupAnalysis";
    public static final String BOOKGROUP_ANALYSIS_COUNT = CacheConstant.BOOK+"BOOKGROUP:listPageBookGroupAnalysis_count";
}
