package com.pcloud.book.group.enums;

import java.util.Objects;
import java.util.Optional;

public interface IMaskFlag {

    int getFlag();

    default boolean defaultState() {
        return false;
    }

    /**
     * 计算辅助工具
     */
    class Helper {
        private int flagVal;

        private Helper(int flagVal) {
            this.flagVal = flagVal;
        }

        public static Helper of() {
            return new Helper(0);
        }

        public static Helper of(Integer flagVal) {
            return new Helper(Optional.ofNullable(flagVal).orElse(0));
        }

        /**
         * 校验标识位是否开启
         *
         * @param maskFlag 掩码表示枚举实现
         * @return 是否开启
         */
        public boolean checkFlagEnable(IMaskFlag maskFlag) {
            if (Objects.isNull(maskFlag)) {
                return false;
            }
            return (flagVal & maskFlag.getFlag()) != 0;
        }

        /**
         * 指定条件开启
         *
         * @param maskFlag 指定条件枚举
         * @return 计算值
         */
        public Helper onState(IMaskFlag maskFlag) {
            flagVal |= maskFlag.getFlag();
            return this;
        }

        /**
         * 指定条件关闭
         *
         * @param maskFlag 指定条件枚举
         * @return 计算值
         */
        public Helper offState(IMaskFlag maskFlag) {
            flagVal &= ~maskFlag.getFlag();
            return this;
        }

        /**
         * 设置条件默认状态
         *
         * @param maskFlag 指定条件枚举
         * @return 计算值
         */
        public Helper defaultState(IMaskFlag maskFlag) {
            return state(maskFlag, maskFlag.defaultState());
        }

        /**
         * 设置条件状态
         *
         * @param maskFlag 指定条件枚举
         * @return 计算值
         */
        public Helper state(IMaskFlag maskFlag, Boolean state) {
            if (state == null) {
                state = maskFlag.defaultState();
            }
            if (state) {
                return onState(maskFlag);
            }
            return offState(maskFlag);
        }

        public int getFlagVal() {
            return flagVal;
        }
    }

}
